Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: /usr/bin/pathfix.py python3-module-setuptools
# END SourceDeps(oneline)
%define oldname python-nitrate
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
%define fontpkgname python-nitrate
Name: python-module-nitrate
Version: 1.6
Release: alt1_5

Summary: Python API for the Nitrate test case management system
License: LGPLv2+

URL: https://github.com/psss/python-nitrate
Source0: %{url}/releases/download/%{version}/%{oldname}-%{version}.tar.bz2

# Depending on the distro, we set some defaults.
# Note that the bcond macros are named for the CLI option they create.
# "%%bcond_without" means "ENABLE by default and create a --without option"

# Fedora or RHEL 8+
%if 0%{?fedora} || 0%{?rhel} > 7
%bcond_with oldreqs
%bcond_with englocale
%else
# The automatic runtime dependency generator doesn't exist yet
%bcond_without oldreqs
# The C.UTF-8 locale doesn't exist, Python defaults to C (ASCII)
%bcond_without englocale
%endif

# For older Fedora and RHEL build python2-nitrate as well
%if 0%{?fedora} > 31 || 0%{?rhel} > 7
%bcond_with python2
%else
%bcond_without python2
%endif

BuildArch: noarch
BuildRequires: git-core
BuildRequires: python3-devel
BuildRequires: python3-module-distribute
BuildRequires: python3-module-six
%if %{with python2}
BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-six
%endif

%{?python_enable_dependency_generator}

%global _description \
A Python interface to the Nitrate test case management system.\
The package consists of a high-level Python module (provides\
natural object interface), a low-level driver (allows to directly\
access Nitrate XMLRPC API) and a command line interpreter (useful\
for fast debugging and experimenting).
Source44: import.info

%description 
%_description


# Python 2
%package -n python3-module-nitrate
Group: Development/Other
Summary: %{summary}
%{?python_provide:%python_provide python3-nitrate}
%if %{with oldreqs}
Requires: python3-module-gssapi
Requires: python3-module-psycopg2
Requires: python3-module-six
%endif
Conflicts: python-module-nitrate < 1.5-3

%description -n python3-module-nitrate 
%_description

%prep
%setup -n %{oldname}-%{version} -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"


%build
%if %{with englocale}
export LANG=en_US.utf-8
%endif
%if %{with python2}
%python_build
%endif
%python3_build

%install
%if %{with englocale}
export LANG=en_US.utf-8
%endif
%if %{with python2}
%python_install
%endif
%python3_install
mkdir -p %{buildroot}%{_mandir}/man1
install -pm 644 docs/*.1.gz %{buildroot}%{_mandir}/man1
# Workaround for https://bugzilla.redhat.com/show_bug.cgi?id=1335203
pathfix.py -pni "%{__python3} %{py3_shbang_opts}i" %{buildroot}%{_bindir}/nitrate

%if %{with python2}
%files -n python-module-nitrate
%{python_sitelibdir_noarch}/nitrate/
%{python_sitelibdir_noarch}/nitrate-*.egg-info/
%doc --no-dereference LICENSE
%endif

%files -n python3-module-nitrate
%{python3_sitelibdir_noarch}/nitrate/
%{python3_sitelibdir_noarch}/nitrate-*.egg-info/
%{_mandir}/man1/*
%{_bindir}/nitrate
%doc README examples
%doc --no-dereference LICENSE

%changelog
