Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%define oldname py-radix
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: python-module-py-radix
Summary: Radix tree data structure for Python
Version: 0.10.0
Release: alt2_7

URL: https://github.com/mjschultz/py-radix
Source0: https://github.com/mjschultz/py-radix/archive/v%{version}.tar.gz

# Define PY_SSIZE_T_CLEAN, use ssize_t as the index type (PEP 353)
# https://github.com/mjschultz/py-radix/pull/55
# Fixes Python 3.10 failures, https://bugzilla.redhat.com/1899466
Patch1: py_ssize_t_clean.patch
#  Change away from deprecated assertEquals and assertNotEquals to assertEqual
Patch2: https://patch-diff.githubusercontent.com/raw/mjschultz/py-radix/pull/44.patch

License: BSD with advertising
BuildRequires: gcc
Source44: import.info

%description
py-radix is an implementation of a radix tree for Python, which
supports storage and lookups of IPv4 and IPv6 networks.

The radix tree (a.k.a Patricia tree) is the data structure most
commonly used for routing table lookups. It efficiently stores
network prefixes of varying lengths and allows fast lookups of
containing networks. py-radix's implementation is built solely
for networks (the data structure itself is more general).

%package -n python3-module-py-radix
Group: Development/Other
Summary: Radix tree data structure for Python

BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools
# Needed for tests
BuildRequires: pytest3 python3-module-pytest

%{?python_provide:%python_provide python3-%{oldname}}

%description -n python3-module-py-radix
py-radix is an implementation of a radix tree for Python, which
supports storage and lookups of IPv4 and IPv6 networks.

The radix tree (a.k.a Patricia tree) is the data structure most
commonly used for routing table lookups. It efficiently stores
network prefixes of varying lengths and allows fast lookups of
containing networks. py-radix's implementation is built solely
for networks (the data structure itself is more general).

%prep
%setup -n %{oldname}-%{version} -q
%patch1 -p1
%patch2 -p1

rm -f inet_ntop.c strlcpy.c
touch inet_ntop.c strlcpy.c

%build
%python3_build

%install
%python3_install

%check
py.test-3 -v

%files -n python3-module-py-radix
%doc README.rst
%doc --no-dereference LICENSE
%{python3_sitelibdir}/py_radix*
%{python3_sitelibdir}/radix*

%changelog
