Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%add_findreq_skiplist /usr/bin/*
%define oldname python-simplevisor
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

%global srcname simplevisor

Name:		python-module-simplevisor
Version:	1.3
Release:	alt1_4
Summary:	Python simple daemons supervisor
License:	ASL 2.0
URL:		https://github.com/cern-mig/%{oldname}
Source0:        http://pypi.python.org/packages/source/s/%{srcname}/%{srcname}-%{version}.tar.gz
BuildArch:	noarch
BuildRequires:	python3-devel
%if 0%{?fedora} >= 24
BuildRequires:	rpm-build-perl
%endif
BuildRequires:	perl(Getopt/Long.pm)
BuildRequires:	perl(List/Util.pm)
BuildRequires:	perl(No/Worries.pm)
BuildRequires:	perl(No/Worries/Die.pm)
BuildRequires:	perl(No/Worries/Log.pm)
BuildRequires:	perl(No/Worries/PidFile.pm)
BuildRequires:	perl(No/Worries/Proc.pm)
BuildRequires:	perl(No/Worries/Syslog.pm)
BuildRequires:	perl(No/Worries/Warn.pm)
BuildRequires:	perl(Pod/Usage.pm)
BuildRequires:	perl(sigtrap.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Time/HiRes.pm)
BuildRequires:	perl(warnings.pm)

%global _description\
Simplevisor is a simple daemons supervisor, it is inspired by\
Erlang OTP and it can supervise hierarchies of services.
Source44: import.info

%description 
%_description

%package -n python3-module-simplevisor
Group: Development/Other
Summary:	Python simple daemons supervisor

%description -n python3-module-simplevisor
Simplevisor is a simple daemons supervisor, it is inspired by
Erlang OTP and it can supervise hierarchies of services.

%prep
%setup -q -n %{srcname}-%{version}
find . -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'

%build 
%{__python3} setup.py build

%install
rm -fr $RPM_BUILD_ROOT
%{__python3} setup.py install --with-data-files --skip-build --root $RPM_BUILD_ROOT
install -D -m 644 man/%{srcname}.1 $RPM_BUILD_ROOT%{_mandir}/man1/%{srcname}.1;
install -D -m 644 man/%{srcname}-control.1 $RPM_BUILD_ROOT%{_mandir}/man1/%{srcname}-control.1;
install -D -m 644 man/%{srcname}-loop.1 $RPM_BUILD_ROOT%{_mandir}/man1/%{srcname}-loop.1;

%check
%{__python3} setup.py test
# And remove compiled documentation.
rm -f test/*.pyc

%files -n python3-module-simplevisor
%doc LICENSE README.rst CHANGES
%{_mandir}/man?/%{srcname}.1*
%{_mandir}/man?/%{srcname}-control.1*
%{_mandir}/man?/%{srcname}-loop.1*
%attr(755, root, root) /usr/bin/simplevisor
%attr(755, root, root) /usr/bin/simplevisor-control
%attr(755, root, root) /usr/bin/simplevisor-loop
%{python3_sitelibdir_noarch}/%{srcname}-%{version}-py%{__python3_version}.egg-info
%{python3_sitelibdir_noarch}/%{srcname}/

%changelog
