Group: Development/Python
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
%define oldname python-tld
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pypi_name tld
%bcond_with network

Name:           python-module-tld
Version:        0.13
Release:        alt1_5
Summary:        Extract the top level domain from the URL given

License:        MPL-1.1 OR GPL-2.0-only OR LGPL-2.1-or-later
URL:            https://github.com/barseghyanartur/tld
Source0:        https://github.com/barseghyanartur/tld/archive/%{version}/%{pypi_name}-%{version}.tar.gz
BuildArch:      noarch
Source44: import.info

%description
Extract the top level domain (TLD) from the URL given. List of TLD names is
taken from Mozilla.

%package -n python3-module-tld
Group: Development/Python
Summary:        %{summary}

BuildRequires:  python3-devel
BuildRequires:  python3-module-six
BuildRequires:  python3-module-pkg_resources python3-module-setuptools

%if %{with network}
BuildRequires: python3-module-coverage
BuildRequires: python3-module-factory_boy
BuildRequires: python3-module-faker
BuildRequires: pytest3 python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-pytest-runner
BuildRequires: python3-module-tox
%endif
%{?python_provide:%python_provide python3-%{pypi_name}}

%description -n python3-module-tld
Extract the top level domain (TLD) from the URL given. List of TLD names is
taken from Mozilla.

%package -n python-module-tld-doc
Group: Development/Python
Summary:        The %{oldname} documentation

BuildRequires:  python3-module-sphinx python3-module-sphinx-sphinx-build-symlink
BuildArch: noarch

%description -n python-module-tld-doc
Documentation for %{oldname}.

%prep
%setup -q -n %{pypi_name}-%{version}

%build
%python3_build
PYTHONPATH=${PWD} sphinx-build-3 docs html
rm -rf html/.{doctrees,buildinfo}

%install
%python3_install

%if %{with network}
%check
# Don't test the CLI part
PYTHONPATH=%{buildroot}%{python3_sitelibdir_noarch} py.test-3 -v --pyargs tld.tests \
 -k "not test_1_update_tld_names_command and not test_1_update_tld_names_mozilla_command and not test_18_update_tld_names_cli" 
%endif

%files -n python3-module-tld
%doc CHANGELOG.rst CREDITS.rst README.rst
%doc --no-dereference LICENSE_GPL2.0.txt LICENSE_LGPL_2.1.txt LICENSE_MPL_1.1.txt
%{_bindir}/update-tld-names
%{python3_sitelibdir_noarch}/%{pypi_name}/
%{python3_sitelibdir_noarch}/%{pypi_name}-%{version}-py*.egg-info/
%exclude %{python3_sitelibdir_noarch}/%{pypi_name}/tests/

%files -n python-module-tld-doc
%doc html
%doc --no-dereference LICENSE_GPL2.0.txt LICENSE_LGPL_2.1.txt LICENSE_MPL_1.1.txt

%changelog
