# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
%define oldname python-unicodenazi
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}

%global srcname unicode-nazi
%global modname unicodenazi

Name:           python-module-unicodenazi
Version:        1.1
Release:        alt1_13
Summary:        Module that finds unicode/bytestring comparisons and other problems

Group:          Development/Other
License:        BSD
URL:            http://pypi.python.org/pypi/%{srcname}
Source0:        http://pypi.python.org/packages/source/u/%{srcname}/%{srcname}-%{version}.tar.gz
# License file from the upstream repo.  Submitted a MANIFEST.in upstream to
# automatically include this in the future
Source1:        http://github.com/mitsuhiko/unicode-nazi/raw/master/LICENSE

BuildArch:      noarch
BuildRequires:  python-devel

%global _description\
A common source of unicode issues in python2 is that code mixes str and unicode\
and is valid for the cases the author tests for (because they only test with\
ASCII) but then throws an error when the code is used with non-ASCII strings.\
\
If enabled unicodenazi will complain when this mixing of unicode and byte str\
occurs.  It's annoying as hell, has a huge runtime impact on performance, and\
will also complain about most of the stuff in the Python standard library.  But\
it will point out some areas of your code that may traceback in python2 when\
given different data and make it easier to migrate to python3 where unicode and\
bytes no longer interoperate.
Source44: import.info

%description %_description

%prep
%setup -q -n %{srcname}-%{version}
cp %{SOURCE1} .

%build
%{__python} setup.py build


%install
%{__python} setup.py install --skip-build --root %{buildroot}

 
%files -n python-module-unicodenazi
%doc README LICENSE
%{python_sitelibdir_noarch}/*


%changelog
