Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{?python_enable_dependency_generator}

Name:           pywbem
Version:        0.15.0
Epoch:          1
Release:        alt2_7
Summary:        Python WBEM client interface and related utilities
License:        LGPLv2
URL:            https://github.com/pywbem/pywbem
Source0:        https://github.com/pywbem/pywbem/archive/v%{version}/%{name}-%{version}.tar.gz
Patch1:         BZ_1922368.patch
BuildRequires:  pip python3-module-pip python3-module-yaml python3-module-ply rpm-build-python3
BuildRequires:  python3-devel
BuildRequires:  python3-module-pkg_resources python3-module-setuptools
BuildArch:      noarch
Source44: import.info

%description
A Python library for making CIM (Common Information Model) operations over HTTP\
using the WBEM CIM-XML protocol. It is based on the idea that a good WBEM\
client should be easy to use and not necessarily require a large amount of\
programming knowledge. It is suitable for a large range of tasks from simply\
poking around to writing web and GUI applications.\
\
WBEM, or Web Based Enterprise Management is a manageability protocol, like\
SNMP, standardized by the Distributed Management Task Force (DMTF) available\
at http://www.dmtf.org/standards/wbem.\
\
It also provides a Python provider interface, and is the fastest and\
easiest way to write providers on the planet.

%package -n python3-module-sblim-wbemcli
Group: Development/Python3
Summary:        Python3 WBEM Client and Provider Interface
BuildArch:      noarch

%description -n python3-module-sblim-wbemcli
A WBEM client allows issuing operations to a WBEM server, using the CIM
operations over HTTP (CIM-XML) protocol defined in the DMTF standards DSP0200
and DSP0201. The CIM/WBEM infrastructure is used for a wide variety of systems
management tasks supported by systems running WBEM servers. See WBEM Standards
for more information about WBEM.

%prep
%setup -q -n %{name}-%{version}
%setup -q
%patch1 -p1


%build
CFLAGS="%{optflags}" %{__python3} setup.py build


%install
env PYTHONPATH=%{buildroot}/%{python3_sitelibdir_noarch} \
    %{__python3} setup.py install -O1 --skip-build --root %{buildroot}
rm -rf %{buildroot}/usr/bin/*.bat
# wbemcli are conflicting with sblim-wbemcli
mv -v %{buildroot}/%{_bindir}/wbemcli %{buildroot}/%{_bindir}/pywbemcli
sed -i -e 's/wbemcli/pywbemcli/' %{buildroot}/%{_bindir}/pywbemcli
mv -v %{buildroot}/%{_bindir}/wbemcli.py %{buildroot}/%{_bindir}/pywbemcli.py

%files -n python3-module-sblim-wbemcli
%doc --no-dereference LICENSE.txt
%{python3_sitelibdir_noarch}/*.egg-info
%{python3_sitelibdir_noarch}/pywbem/
%{python3_sitelibdir_noarch}/pywbem_mock/
%{_bindir}/mof_compiler
%{_bindir}/pywbemcli
%{_bindir}/pywbemcli.py
%doc README.rst

%changelog
