Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++ qt5-tools-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%undefine __cmake_in_source_build

Summary: A viewer for comic book archives
Name:    qcomicbook
Version: 0.9.1
Release: alt1_10

License: GPLv2
URL:     https://github.com/stolowski/QComicBook/
Source0: https://github.com/stolowski/QComicBook/archive/%{version}/%{name}-%{version}.tar.gz
# https://github.com/stolowski/QComicBook/pull/30
Patch1: qcomicbook-12638e6947c95657dfdb0f779528260bace72a47.patch
Patch2: qcomicbook-123b0f02c3860f122e55029d29c75bdb9431034d.patch

BuildRequires: ctest cmake
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(poppler-qt5)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: qt5-designer qt5-tools
Source44: import.info
#BuildRequires: pkgconfig(xmu)
#BuildRequires: pkgconfig(xi)

#%%{?_qt5_version:Requires: qt5%%{?_isa} >= %%{_qt5_version}}
## runtime utilities for viewing comic book archives
#Requires: bzip2
#Requires: gzip
#Requires: p7zip
#Requires: tar
#Requires: unzip
## nonfree stuff
#Requires: unace
#Requires: unrar


%description
QComicBook is a viewer for PDF files and comic book archives containing
jpeg/png/xpm/gif/bmp images, which aims at convenience and simplicity.
Features include: automatic unpacking of archive files, full-screen mode, continuous
scrolling mode, double-pages viewing, manga mode, thumbnails view, page scaling,
mouse or keyboard navigation etc.

You will also need unzip, rar (or unrar), unace, p7zip and tar (with gzip and
bzip2 support compiled in) somewhere in your PATH to handle archives. If one of
these tools is missing you can still use QComicBook, but you won't be able to
open some archives. You may check status of supported archives via Help > System information
menu option of QComicBook.


%prep
%setup -q -n QComicBook-%{version}
%patch1 -p1
%patch2 -p1



%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build


%install
%fedora_v2_cmake_install

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
cat > $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Ryan Lerch <rlerch@redhat.com> -->
<!--
EmailAddress: stolowski@gmail.com
SentUpstream: 2014-09-18
-->
<application>
  <id type="desktop">qcomicbook.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <summary>Read comics</summary>
  <description>
    <p>
      QComicBook is an application for reading comics and supports a wide
      range of formats, including CBZ, CBR and CBT.
      QComicBook has a wide range of features to enhance your comic reading,
      including page preview, a thumbnails view, bookmarks, and a specific
      mode for reading manga.
    </p>
  </description>
  <url type="homepage">http://qcomicbook.org/</url>
  <screenshots>
    <screenshot type="default">http://qcomicbook.org/screenshots/qcomicbook072-os2.png</screenshot>
  </screenshots>
</application>
EOF

%find_lang qcomicbook --without-mo --with-qt


%check
desktop-file-validate ${RPM_BUILD_ROOT}%{_datadir}/applications/*%{name}.desktop

%files -f qcomicbook.lang
%doc AUTHORS README ChangeLog COPYING THANKS TODO
%{_bindir}/qcomicbook
%{_mandir}/man1/qcomicbook.1*
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/qcomicbook.desktop
%{_datadir}/pixmaps/qcomicbook.png
%dir %{_datadir}/qcomicbook/
%dir %{_datadir}/qcomicbook/i18n/


%changelog
