Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-ruby rpm-macros-java
BuildRequires: perl-podlators
# END SourceDeps(oneline)
BuildRequires: chrpath
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		qdbm
Version:	1.8.78
Release:	alt10_58
License:	LGPLv2+

URL:		http://fallabs.com/qdbm/
Source0:	http://fallabs.com/qdbm/%{name}-%{version}.tar.gz
# Copied from Debian package
Patch0:		qdbm-ruby-1.9-compat.patch
# Java 13 introduced yield keyword and the original yield()
# must be called with explicit receiver
Patch1:		qdbm-1.8.78-java17-yield-usage.patch
# ruby module: conformant for c99, -Werror=implicit-int
Patch2:		qdbm-1.8.78-ruby-module-c99-conformant.patch

BuildRequires:	gcc-c++
BuildRequires:	zlib-devel
BuildRequires:	bzlib-devel
BuildRequires:	liblzo2-devel
BuildRequires:	java-devel
# ruby-devel requires ruby-libs but not require ruby
BuildRequires:	erb
BuildRequires:	libruby-devel
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
# java related macros
BuildRequires:	javapackages-tools

Summary:	Quick Database Manager
Source44: import.info

%description
QDBM is an embedded database library compatible with GDBM and NDBM.
It features hash database and B+ tree database and is developed referring
to GDBM for the purpose of the following three points: higher processing
speed, smaller size of a database file, and simpler API.


%package devel
Group: Development/Other
Summary:	Libraries and Header files for QDBM Database library
Requires:	%{name} = %{version}-%{release}

%description devel
This is the development package that provides header files and libraries
for QDBM library.


%package cgi
Group: Text tools
Summary:	CGI interface for QDBM Database
Requires:	%{name} = %{version}-%{release}
Requires:	webserver

%description cgi
This package contains a CGI interface for QDBM Database.


%package java
Group: System/Libraries
Summary:	QDBM Database Library for Java
Requires:	%{name} = %{version}-%{release}
Requires:	java-headless

%description java
This package contains a Java interface for QDBM Database library.

%package javadoc
Group: Documentation
Summary:	API docs for QDBM Database Library Java interface
BuildArch:	noarch

%description javadoc
This package contains the API documentation for the QDBM Database library Java
interface.


%package perl
Group: System/Libraries
Summary:	QDBM Database Library for Perl
Requires:	%{name} = %{version}-%{release}

%description perl
This package contains a Perl interface for QDBM Database library.


%package -n qdbm++
Group: System/Libraries
Summary:	QDBM Database Library for C++
Requires:	%{name} = %{version}-%{release}

%description -n qdbm++
This package contains a C++ interface for QDBM Database library.

%package -n qdbm++-devel
Group: Development/Other
Summary:	Libraries and Header files for QDBM C++ interface
Requires:	qdbm++ = %{version}-%{release}

%description -n qdbm++-devel
This is the development package that provides header files and libraries
for QDBM C++ interface.


%package -n ruby-qdbm
Group: System/Libraries
Summary:	QDBM Database Library for Ruby
Requires:	%{name} = %{version}-%{release}
Provides:	ruby(qdbm) = %{version}-%{release}

%description -n ruby-qdbm
This package contains a Ruby interface for QDBM Database library.


%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1


# Fix path in doc/index*.html
sed -i.link  \
	-e 's|"spex|"../%{name}-devel-%{version}/spex|' \
	-e 's|"xspex|"../%{name}++-devel-%{version}/xspex|' \
	-e 's|"jspex|"../%{name}-java-%{version}/jspex|' \
	-e 's|"plspex|"../%{name}-perl-%{version}/plspex|' \
	-e 's|"rbspex|"../ruby-%{name}-%{version}/rbspex|' \
	-e 's|"cgispex|"../%{name}-cgi-%{version}/cgispex|' \
	doc/index*.html
	
%build
## 0. First:
## - remove rpath
## - fix pc file to hide header files
## - fix Makefile to keep timestamps
for f in `find . -name Makefile.in` ; do
	sed -i.rpath -e '/^LDENV/d' $f
done
sed -i.misc \
	 -e '/^Libs/s|@LIBS@||' \
	 -e '/Cflags/s|^\(.*\)|\1 -I\${includedir}/qdbm|' \
	 qdbm.pc.in
sed -i.stamp \
	 -e 's|cp \(-R*f \)|cp -p \1| ' \
	 -e 's|^CP =.*$|CP = cp -p|' \
	`find . -name \*[mM]akefile.in -or -name \*[mM]akefile`
	 

## 1. for main
sed -i.flags -e '/^CFLAGS/s|-O3.*$|%{optflags}|' Makefile.in
%configure \
	--enable-pthread \
	--enable-zlib \
	--enable-bzip \
	--enable-iconv \
	--enable-lzo
make %{?_smp_mflags}

## 2. for C++
pushd plus
sed -i.flags -e '/^CXXFLAGS/s|@MYOPTS@|%{optflags}|' Makefile.in
%configure
make %{?_smp_mflags}
popd

## 3. for java
pushd java
sed -i.flags -e '/^CFLAGS/s|@MYOPTS@|%{optflags}|' Makefile.in
export JAVA_HOME=%{java_home}
%configure
make JAR=%{jar} JAVAC=%{javac}
popd

## 4. for cgi
pushd cgi
sed -i.flags -e \
	 '/^CFLAGS/s|-O2.*$|%{optflags} -DCONFDIR="\"@sysconfdir@/qdbm/\""|' Makefile.in
%configure
make %{?_smp_mflags}
popd

## 5. for perl
pushd perl
%configure
make %{?_smp_mflags} CC="gcc %optflags" LDDLFLAGS="-shared" INSTALLDIRS=vendor
popd

## 6. for Ruby
pushd ruby
%configure
sed -i 's|extconf.rb |extconf.rb --vendor |' Makefile
make %{?_smp_mflags} CC="gcc %optflags"
popd


%install

## 1. for main
make install DESTDIR=$RPM_BUILD_ROOT

rm -rf $RPM_BUILD_ROOT%{_libdir}/lib*.a
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{name}/

## 2. for cgi
pushd cgi
make install DESTDIR=$RPM_BUILD_ROOT
popd

rm -rf $RPM_BUILD_ROOT%{_datadir}/%{name}/cgi/*.html
install -d $RPM_BUILD_ROOT%{_sysconfdir}/qdbm

mv $RPM_BUILD_ROOT%{_datadir}/qdbm/cgi/*.conf \
	$RPM_BUILD_ROOT%{_sysconfdir}/qdbm/
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm/cgi
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm

## 3. for java
pushd java
make install DESTDIR=$RPM_BUILD_ROOT JAR=%{jar}
popd

mkdir -p $RPM_BUILD_ROOT%{_jnidir}
mv -f $RPM_BUILD_ROOT%{_libdir}/*.jar \
	$RPM_BUILD_ROOT%{_jnidir}

mkdir -p $RPM_BUILD_ROOT%{_javadocdir}
mv $RPM_BUILD_ROOT%{_datadir}/qdbm/java/japidoc \
	$RPM_BUILD_ROOT%{_javadocdir}/%{name}
rm $RPM_BUILD_ROOT%{_datadir}/qdbm/java/*.html
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm/java
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm

## 4. for perl
pushd perl
make install DESTDIR=$RPM_BUILD_ROOT INSTALLDIRS=vendor
popd

rm -rf $RPM_BUILD_ROOT%{_datadir}/qdbm/perl/plapidoc
rm $RPM_BUILD_ROOT%{_datadir}/qdbm/perl/*.html
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm/perl
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm

# Fix perl modules..
rm $RPM_BUILD_ROOT%{perl_vendor_archlib}/perllocal.pod
find $RPM_BUILD_ROOT%{perl_vendor_archlib} \
	-name \*.bs -or -name .packlist | \
	xargs rm -f
find $RPM_BUILD_ROOT%{perl_vendor_archlib} \
	-name \*.so | \
	xargs chmod 0755

## 5. for C++
pushd plus
make install DESTDIR=$RPM_BUILD_ROOT
popd

rm -rf $RPM_BUILD_ROOT%{_libdir}/lib*.a
rm -rf $RPM_BUILD_ROOT%{_datadir}/qdbm/plus/xapidoc
rm $RPM_BUILD_ROOT%{_datadir}/qdbm/plus/*.html
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm/plus
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm

## 6. for Ruby
pushd ruby
make install DESTDIR=$RPM_BUILD_ROOT
popd

rm -rf $RPM_BUILD_ROOT%{_datadir}/qdbm/ruby/rbapidoc
rm $RPM_BUILD_ROOT%{_datadir}/qdbm/ruby/*.html
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm/ruby
rmdir $RPM_BUILD_ROOT%{_datadir}/qdbm

## 7. Finally hide header files to name specific directory
pushd $RPM_BUILD_ROOT%{_includedir}
for f in *.h ; do
	for g in *.h ; do
		eval sed -i -e \'s\|include \<$g\>\|include \"$g\"\|\' $f
	done
done

mkdir qdbm
mv *.h qdbm/
popd
# kill rpath
for i in `find %buildroot{%_bindir,%_libdir,/usr/libexec,/usr/lib,/usr/sbin} -type f -perm -111 ! -name '*.la' `; do
	chrpath -d $i ||:
done








%files
%doc COPYING ChangeLog NEWS README THANKS
%doc doc/*png
%doc doc/index.html
%lang(ja) %doc doc/index.ja.html

%{_bindir}/[a-wyz]*
%exclude %{_bindir}/pl*
%exclude %{_bindir}/rb*

%{_libdir}/libqdbm.so.*
# own includedir
%dir %{_includedir}/qdbm/
%{_mandir}/man1/*

%files devel
%doc doc/spex.html
%lang(ja) %doc doc/spex-ja.html
%{_mandir}/man3/*

%{_includedir}/qdbm/[a-w]*.h
%{_libdir}/libqdbm.so
%{_libdir}/pkgconfig/*.pc

%files cgi
%doc cgi/cgispex.html
%lang(ja) %doc cgi/cgispex-ja.html

%{_libexecdir}/*.cgi
%dir %{_sysconfdir}/qdbm/
%config(noreplace) %{_sysconfdir}/qdbm/*.conf

%files java
%doc java/jspex.html
%lang(ja) %doc java/jspex-ja.html

%{_libdir}/libjqdbm.so*
%{_jnidir}/*.jar

%files javadoc
%doc %{_javadocdir}/%{name}/

%files perl
%doc perl/plapidoc/
%doc perl/plspex.html
%lang(ja) %doc perl/plspex-ja.html

%{_bindir}/pl*
%{perl_vendor_archlib}/*.pm
%{perl_vendor_archlib}/auto/*/

%files -n qdbm++

%{_bindir}/x*
%{_libdir}/libxqdbm.so.*

%files -n qdbm++-devel
%doc plus/xapidoc/
%doc plus/xspex.html
%lang(ja) %doc plus/xspex-ja.html

%{_includedir}/qdbm/x*.h
%{_libdir}/libxqdbm.so

%files -n ruby-qdbm
%doc ruby/rbapidoc/
%doc ruby/rbspex.html
%lang(ja) %doc ruby/rbspex-ja.html

%{_bindir}/rb*
%{ruby_vendorarchdir}/mod_*.so
%{ruby_vendorlibdir}/*.rb


%changelog
