# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ perl(ExtUtils/MakeMaker.pm) perl-devel swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		qesteidutil
Version:	3.12.10
Release:	alt1_6
Summary:	Estonian ID card utility

Group:		Office
License:	LGPLv2
URL:		https://github.com/open-eid/qesteidutil
Source0:	https://github.com/open-eid/qesteidutil/releases/download/v%{version}/%{name}-%{version}.tar.gz
# https://github.com/open-eid/qdigidoc/wiki/DeveloperTips#building-in-sandboxed-environment
Patch0:		qesteidutil-3.12.7-add-missing-conf.patch
Patch1:		qesteidutil-3.12.10-fix-build-against-qt-5.11.0.patch

BuildRequires:	cmake
BuildRequires:	pkgconfig(libpcsclite)
BuildRequires:	pkgconfig(openssl)
BuildRequires:	pkgconfig(Qt5Core)
BuildRequires:	pkgconfig(Qt5Gui)
BuildRequires:	pkgconfig(Qt5Help)
BuildRequires:	pkgconfig(Qt5Network)
BuildRequires:	pkgconfig(Qt5PrintSupport)
BuildRequires:	pkgconfig(Qt5Widgets)

Requires:	pcsc-lite-ccid
Requires:	libopensc opensc
Requires:	pcsc-lite
# fix mga#11352
Requires:	locales-et
Source44: import.info

%description
QEsteidUtil is a user-friendly application for managing Estonian ID Cards.
It can be used to to change and unlock PIN codes, examine the personal 
information stored on the card, extract and view the certificates, set 
up mobile ID and configure a personal @eesti.ee e-mail address.


%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
%{mageia_cmake} -DBREAKPAD=FALSE
%mageia_cmake_build

%install
%mageia_cmake_install

%files
%{_bindir}/qesteidutil
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/qesteidutil.desktop
%{_datadir}/icons/hicolor/*/apps/qesteidutil.png
%{_mandir}/man1/qesteidutil.1*


%changelog
