# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 19
Name:         qfaxreader
License:      GPLv2+
Group:        Communications
Version:      0.3.1
Release:      alt1_19
Summary:      A multipage monochrome/color TIFF/FAX viewer
Source:       http://downloads.sourceforge.net/sourceforge/%{name}/%{name}-%{version}.tar.bz2
Patch0:       qfaxreader-parallel_build.patch
Patch1:       qfaxreader-gcc4.3.0-configure.patch
URL:          http://qfaxreader.sourceforge.net/
BuildRequires:  qt3-devel libtiffxx-devel libtiff-devel gdbm-devel
BuildRequires:  desktop-file-utils
%if "0%{?dist}" >= "0.fc19"
BuildRequires:  autoconf
%endif
Requires:     icon-theme-hicolor
Source44: import.info

%description
QFaxReader is a monochrome/color multipage .TIFF files
visualisation utility designed for viewing faxes.
   
Features:
* multi-page monochrome/color tiff/fax file support
* fullscreen mode
* correctly display fax images in any resolution
* an aliases database for replacing fax IDs with real names
* image transformation (left or right rotation, vertical flipping)
* image export into any format supported by the Qt installation
* auto-refresh and notification of new facsimiles
* a sidebar for easy directory navigation
* printing monocrome and color tiffs
* arbitrary scaling (normal/smooth)
* internationalization support
* CID support

%prep
%setup -q 
%patch0 -p1 -b .parallel_make
%patch1 -p1 -b .gcc430

%build
%if "0%{?dist}" >= "0.fc19"
autoconf
%endif

%if "0%{?dist}" >= "0.fc20"
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} \
       --with-docdir=%{_defaultdocdir}/%{name} --datadir=%{_datadir}   \
       --mandir=%{_mandir} --libdir=%{_libdir}
%else
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{_prefix} \
       --with-docdir=%{_defaultdocdir}/%{name}-%{version} --datadir=%{_datadir}   \
       --mandir=%{_mandir} --libdir=%{_libdir}
%endif
make %{?_smp_mflags}


%install
make install DESTDIR=%{buildroot}

#mkdir -p %{buildroot}/%{_datadir}/applications
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/16x16/apps
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/22x22/apps
mkdir -p %{buildroot}/%{_datadir}/icons/hicolor/32x32/apps
#install -p -m 644 kde/qfaxreader.desktop %{buildroot}/%{_datadir}/applications
install -p -m 644 kde/icon-16.png %{buildroot}/%{_datadir}/icons/hicolor/16x16/apps/qfaxreader.png
install -p -m 644 kde/icon-22.png %{buildroot}/%{_datadir}/icons/hicolor/22x22/apps/qfaxreader.png
install -p -m 644 kde/icon-32.png %{buildroot}/%{_datadir}/icons/hicolor/32x32/apps/qfaxreader.png

desktop-file-install                                    \
%if 0%{?fedora} && 0%{?fedora} < 19
        --vendor "fedora"                               \
%endif
        --remove-category Application                   \
        --dir %{buildroot}/%{_datadir}/applications     \
        kde/qfaxreader.desktop

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{_datadir}/man/man1/*
%{_bindir}/*
%{_datadir}/icons/*/*/apps/*
%{_datadir}/applications/*


%changelog
