# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	A MIDI Network Gateway via UDP/IP Multicast
Name:		qmidinet
Version:	0.9.11
Release:	alt1_1
License:	GPLv2+
Group:		Sound
URL:		https://qmidinet.sourceforge.net/
Source0:	https://sourceforge.net/projects/qmidinet/files/qmidinet/%{version}/%{name}-%{version}.tar.gz
BuildRequires:	desktop-file-utils
BuildRequires:	ccmake cmake ctest
BuildRequires:	qt5-tools qt6-designer qt6-tools
BuildRequires:	pkgconfig(Qt6Core)
BuildRequires:	pkgconfig(Qt6Gui)
BuildRequires:	pkgconfig(Qt6Network)
BuildRequires:	pkgconfig(Qt6Svg)
BuildRequires:	pkgconfig(Qt6Widgets)
BuildRequires:	pkgconfig(jack)
BuildRequires:	pkgconfig(alsa)
Source44: import.info

%description
QmidiNet is a MIDI network gateway application that sends and receives
MIDI data (ALSA Sequencer and/or JACK MIDI) over the network, using UDP/IP
multicast. Inspired by multimidicast (https://llg.cubic.org/tools) and
designed to be compatible with ipMIDI for Windows (http://nerds.de).

%prep
%setup -q


%build
%{mageia_cmake_qt6}
%mageia_cmake_build

%install
%mageia_cmake_install

#menu
desktop-file-install \
  --remove-key="X-SuSE-translate" \
  --remove-key="Version" \
  --add-category="X-Mageia-CrossDesktop" \
  --dir %{buildroot}%{_datadir}/applications \
%{buildroot}%{_datadir}/applications/org.rncbc.%{name}.desktop

%files
%doc ChangeLog README
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_datadir}/applications/org.rncbc.%{name}.desktop
%{_metainfodir}/org.rncbc.%{name}.metainfo.xml
%{_iconsdir}/hicolor/32x32/apps/org.rncbc.%{name}.png
%{_iconsdir}/hicolor/scalable/apps/org.rncbc.%{name}.svg
%{_mandir}/man1/%{name}*.1*
%lang(fr) %{_mandir}/fr/man1/%{name}*.1*


%changelog
