Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: groff-ps
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define fontpkgname qotd
%global commit0 fdab195ed5ec8e4aae31949703a5304712f11642

Name:           qotd
Version:        0.11.3
Release:        alt2_13
Summary:        A simple and lightweight Quote of the Day daemon

License:        GPLv2+
URL:            https://gitlab.com/ammongit/qotd
Source0:        https://gitlab.com/ammongit/%{name}/repository/archive.tar.gz?ref=v%{version}#/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-homed systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
BuildRequires:  git
BuildRequires:  groff-base groff-dvi groff-extra groff-lbp groff-lj4
BuildRequires:  ghostscript-utils ghostscript

%{?systemd_requires}
Source44: import.info

%description
QOTD (quote of the day) is specified in RFC 865 as a way of broadcasting a
quote to users. On both TCP and UDP, port 17 is officially reserved for
this purpose. This program is meant to provide a simple QOTD daemon on
IPv4 and IPv6 over TCP/IP.

%prep
%setup -q -n %{name}-v%{version}-%{commit0}


%build
%make_build CFLAGS="%{optflags} %{__global_ldflags}"
make -C man

%install
make install ROOT=%{buildroot}

# Build script autoinstalls qotd.pdf, so copy README there.
cp -a README.md %{buildroot}/%{_docdir}/%{name}/

# Installs systemd service file.
mkdir -p %{buildroot}%{_unitdir}
cp -a misc/qotd.service %{buildroot}%{_unitdir}/

%post
%post_service qotd

%preun
%preun_service qotd

%files
%doc --no-dereference LICENSE
%doc %{_docdir}/%{name}/
%{_bindir}/qotdd
%{_mandir}/man5/qotd.conf.5*
%{_mandir}/man8/qotdd.8*
%{_datadir}/qotd
%{_unitdir}/qotd.service
%config(noreplace) %{_sysconfdir}/qotd.conf

%changelog
