Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           qsstv
Version:        9.5.8
Release:        alt2_17
Summary:        Qt-based slow-scan TV and fax

License:        GPLv2+
URL:            https://www.qsl.net/on4qz/

Source0:        https://www.qsl.net/o/on4qz/qsstv/downloads/%{name}_%{version}.tar.gz
Source1:        qsstv.1
Source2:        net.qsl.QSSTV.metainfo.xml
Source3:        qsstv.png

Patch0:         qsstv-install.patch

BuildRequires:  gcc-c++ doxygen desktop-file-utils
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  libfftw3-devel
BuildRequires:  qt5-base-devel
BuildRequires:  libqwt6-qt5-devel
BuildRequires:  hamlib-c++-devel hamlib-devel hamlib-tcl
BuildRequires:  libalsa-devel
BuildRequires:  libpulseaudio-devel
BuildRequires:  libopenjpeg2.0-devel
BuildRequires:  libv4l-devel
Source44: import.info


%description
Qsstv is a program for receiving slow-scan television and fax. These are
modes used by hamradio operators. Qsstv uses a soundcard to send and
receive images.


%package doc
Group: Communications
Summary:             User manual for Qsstv.
BuildArch:           noarch
Requires:            %{name} = %{version}-%{release}

%description doc
User manual for Qsstv.


%prep
%setup -q -n %{name}
%patch0 -p1


# Honor build flags...
sed -i "s/\-O0/\-O2/g" qsstv.pro


%build 
# mode_and_occupancy_code_table has different sizes  in its declaration
# vs its definition.  This is a hard error when using LTO and must be
# resolved before this package can use LTO
%define _lto_cflags %{nil}

qmake-qt5 PREFIX=%{_prefix} CONFIG+=debug QMAKE_CXXFLAGS+="-std=c++14 %{optflags}"
%make_build


%install
export INSTALL_ROOT=%{buildroot}
make install 

# Install icon
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/64x64/apps/
install -pm 0644 %{SOURCE3} %{buildroot}%{_datadir}/icons/hicolor/64x64/apps/

desktop-file-validate %{buildroot}%{_datadir}/applications/%{name}.desktop

# Install man page borrowed from Debian
mkdir -p %{buildroot}%{_mandir}/man1
install -pm 0644 %{SOURCE1} %{buildroot}%{_mandir}/man1/

# Install metainfo file
%if 0%{?fedora}
mkdir -p %{buildroot}%{_metainfodir}
install -pm 0644 %{SOURCE2} %{buildroot}%{_metainfodir}/
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/*.metainfo.xml
%endif

find %{buildroot} -type f -name "*.a" -exec rm -f {} \;


%files
%doc --no-dereference COPYING
%doc README.txt
%{_bindir}/* 
%{_datadir}/icons/hicolor/64x64/apps/%{name}.png
%{_datadir}/applications/*%{name}.desktop
%{_mandir}/man1/%{name}.1*
%{?fedora:%{_metainfodir}/*.metainfo.xml}

%files doc
%{_docdir}/%{name}/


%changelog
