Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Upstream uses weird versioning convention
%global upstreamver 2.3_1-opensource

Summary:    QIODevice that compresses data streams
Name:       qtiocompressor
Version:    2.3.1
Release:    alt2_31
License:    GPLv3 or LGPLv2 with exceptions
URL:        http://qt.nokia.com/products/appdev/add-on-products/catalog/4/Utilities/qtiocompressor/

# The original source was http://get.qt.nokia.com/qt/solutions/lgpl/qtiocompressor-%%{upstreamver}.tar.gz but is unavailable.
# A merge request to reimport this module to qt-solutions is already open at https://codereview.qt-project.org/#/c/58895/
Source0:    https://fale.fedorapeople.org/qtiocompressor/qtiocompressor-%{upstreamver}.tar.gz
# To add qmake support for convenience for packages using this library:
# http://bugreports.qt.nokia.com/browse/QTSOLBUG-119
Source1:    qtiocompressor.prf

# Don't build examples:
Patch0:     qtiocompressor-build.patch
# Use Qt5 library
Patch1:     qtiocompressor-2.3.1_use-qt5-lib.patch

BuildRequires:  qt5-base-devel
BuildRequires:  zlib-devel
Source44: import.info

%description
The class works on top of a QIODevice subclass, compressing data before it is
written and decompressing it when it is read. Since QtIOCompressor works on
streams, it does not have to see the entire data set before compressing or
decompressing it. This can reduce the memory requirements when working on large
data sets.


%package    devel
Group: Development/Other
Summary:    Development files for %{name}
Requires:   %{name} = %{version}-%{release}

%description    devel
This package contains libraries and header files for developing applications
that use QtIOCompressor.


%prep
%setup -q -n %{name}-%{upstreamver}
%patch0 -p1
%patch1 -p1



%build
touch .licenseAccepted
# Does not use GNU configure
./configure -library
%qmake_qt5
%make_build


%install
# libraries
mkdir -p %{buildroot}%{_qt5_libdir}
cp -a lib/* %{buildroot}%{_qt5_libdir}
chmod 755 %{buildroot}%{_qt5_libdir}/*.so.*.*.*

# headers
mkdir -p %{buildroot}%{_qt5_headerdir}/QtSolutions
cp -a \
    src/qtiocompressor.h \
    src/QtIOCompressor \
    %{buildroot}%{_qt5_headerdir}/QtSolutions

mkdir -p %{buildroot}%{_qt5_libdir}/qt5/mkspecs/features/
cp -a %{SOURCE1} %{buildroot}%{_qt5_libdir}/qt5/mkspecs/features/



%files
%doc --no-dereference LGPL_EXCEPTION.txt LICENSE.*
%doc README.TXT
%{_qt5_libdir}/lib*.so.1*


%files devel
%doc doc examples
%{_qt5_libdir}/lib*.so
%{_qt5_headerdir}/QtSolutions/
%{_qt5_libdir}/qt5/mkspecs/features/%{name}.prf


%changelog
