Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if (0%{?fedora} || 0%{?rhel} < 8) && ! 0%{?flatpak}
%global _with_qt4      1
%endif

%global commit0	   5a07df503a6f01280f493cbcc2aace462b9dee57
%global commitdate 20150629

%global shortcommit0 %(c=%{commit0}; echo ${c:0:7})

Summary:	QFile extension with advisory locking functions
Name:		qtlockedfile
Version:	2.4
Release:	alt2_42.%{commitdate}git%{shortcommit0}

License:	GPLv3 or LGPLv2 with exceptions
URL:		http://doc.qt.digia.com/solutions/4/qtlockedfile/qtlockedfile.html
Source0:	https://github.com/qtproject/qt-solutions/archive/%{commit0}.tar.gz#/%{name}-%{commit0}.tar.gz
Source1:	qtlockedfile.prf.in
# Proposed upstream in https://codereview.qt-project.org/#/c/92411/
Source2:	LICENSE.LGPL
# Proposed upstream in https://codereview.qt-project.org/#/c/92411/
Source3:	LGPL_EXCEPTION
# Proposed upstream in https://codereview.qt-project.org/#/c/92411/
Source4:	LICENSE.GPL3
%{?_with_qt4:BuildRequires:	libqt4-declarative libqt4-devel libqt4-help qt4-designer qt4-doc-html qt5-declarative-devel qt5-designer qt5-tools}
BuildRequires:	qt5-base-devel
BuildRequires:	qt5-tools qt6-base-devel
Source44: import.info

%description
This class extends the QFile class with inter-process file locking capabilities.
If an application requires that several processes should access the same file,
QtLockedFile can be used to easily ensure that only one process at a time is
writing to the file, and that no process is writing to it while others are
reading it.

%if 0%{?_with_qt4}
%package devel
Group: Development/C
Summary:	Development files for %{name}
Requires:	%{name} = %{version}-%{release}
Requires:	libqt4-declarative libqt4-help qt4-designer qt4-doc-html qt5-designer qt5-tools

%description devel
This package contains libraries and header files for developing applications
that use QtLockedFile.
%endif

%package qt5
Group: System/Libraries
Summary:	QFile extension with advisory locking functions (Qt5)
Requires:	libqt5-concurrent libqt5-core libqt5-dbus libqt5-network libqt5-sql libqt5-test libqt5-xml

%description qt5
This class extends the QFile class with inter-process file locking capabilities.
If an application requires that several processes should access the same file,
QtLockedFile can be used to easily ensure that only one process at a time is
writing to the file, and that no process is writing to it while others are
reading it.
This is a special build against Qt5.

%package qt5-devel
Group: System/Libraries
Summary:	Development files for %{name}-qt5
Requires:	%{name}-qt5 = %{version}-%{release}

%description qt5-devel
This package contains libraries and header files for developing applications
that use QtLockedFile with Qt5.

%package qt6
Group: System/Libraries
Summary:	QFile extension with advisory locking functions (Qt6)
Requires:	libqt6-concurrent libqt6-core libqt6-dbus libqt6-network libqt6-sql libqt6-test libqt6-xml

%description qt6
This class extends the QFile class with inter-process file locking capabilities.
If an application requires that several processes should access the same file,
QtLockedFile can be used to easily ensure that only one process at a time is
writing to the file, and that no process is writing to it while others are
reading it.
This is a special build against Qt6.

%package qt6-devel
Group: System/Libraries
Summary:	Development files for %{name}-qt6
Requires:	%{name}-qt6 = %{version}-%{release}
Requires:	qt5-tools

%description qt6-devel
This package contains libraries and header files for developing applications
that use QtLockedFile with Qt6.

%prep
%setup -qn qt-solutions-%{commit0}/%{name}
# use versioned soname
sed -i s,head,%{version}, common.pri
# do not build example source
sed -i /example/d %{name}.pro
mkdir licenses
cp %{SOURCE2} %{SOURCE3} %{SOURCE4} licenses


%build
# Does not use GNU configure
./configure -library
%if 0%{?_with_qt4}
%{qmake_qt4}
%make_build
sed -e 's|@QT_INCLUDEDIR@|%{_qt4_headerdir}|' %{SOURCE1} > qtlockedfile.prf
%endif
mkdir qt5
pushd qt5
%qmake_qt5 ..
%make_build
sed -e 's|@QT_INCLUDEDIR@|%{_qt5_headerdir}|' %{SOURCE1} > qtlockedfile.prf
popd
mkdir qt6
pushd qt6
%qmake_qt6 ..
%make_build
sed -e 's|@QT_INCLUDEDIR@|%{_qt6_headerdir}|' %{SOURCE1} > qtlockedfile.prf
popd

%install
# libraries
mkdir -p %{buildroot}%{_libdir}
cp -ap lib/* %{buildroot}%{_libdir}

# headers
%if 0%{?_with_qt4}
mkdir -p %{buildroot}%{_qt4_headerdir}/QtSolutions
cp -ap src/qtlockedfile.h src/QtLockedFile %{buildroot}%{_qt4_headerdir}/QtSolutions
install -p -D -m644 qtlockedfile.prf %{buildroot}%{_qt4_datadir}/mkspecs/features/qtlockedfile.prf
%endif
mkdir -p %{buildroot}%{_qt5_headerdir}/QtSolutions
cp -ap src/qtlockedfile.h src/QtLockedFile %{buildroot}%{_qt5_headerdir}/QtSolutions
install -p -D -m644 qt5/qtlockedfile.prf %{buildroot}%{_qt5_archdatadir}/mkspecs/features/qtlockedfile.prf
mkdir -p %{buildroot}%{_qt6_headerdir}/QtSolutions
cp -ap src/qtlockedfile.h src/QtLockedFile %{buildroot}%{_qt6_headerdir}/QtSolutions
install -p -D -m644 qt6/qtlockedfile.prf %{buildroot}%{_qt6_archdatadir}/mkspecs/features/qtlockedfile.prf

%if 0%{?_with_qt4}
%files
%doc --no-dereference licenses/*
%doc README.TXT
# Caution! do not include any unversioned .so symlink (belongs to -devel)
%{_qt4_libdir}/libQtSolutions_LockedFile*.so.*

%files devel
%doc doc/html/ example/
%{_qt4_headerdir}/QtSolutions/
%{_qt4_libdir}/libQtSolutions_LockedFile*.so
%{_qt4_datadir}/mkspecs/features/qtlockedfile.prf
%endif

%files qt5
%doc --no-dereference licenses/*
%doc README.TXT
# Caution! do not include any unversioned .so symlink (belongs to -devel)
%{_qt5_libdir}/libQt5Solutions_LockedFile*.so.*

%files qt5-devel
%doc doc/html/ example/
%{_qt5_headerdir}/QtSolutions/
%{_qt5_libdir}/libQt5Solutions_LockedFile*.so
%{_qt5_archdatadir}/mkspecs/features/qtlockedfile.prf

%files qt6
%doc --no-dereference licenses/*
%doc README.TXT
# Caution! do not include any unversioned .so symlink (belongs to -devel)
%{_qt6_libdir}/libQt6Solutions_LockedFile*.so.*

%files qt6-devel
%doc doc/html/ example/
%{_qt6_headerdir}/QtSolutions/
%{_qt6_libdir}/libQt6Solutions_LockedFile*.so
%{_qt6_archdatadir}/mkspecs/features/qtlockedfile.prf

%changelog
