# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rafkill
Version:        1.2.3
Release:        alt4_20
Summary:        Top-down shooter with powerups
Group:          Games/Other
License:        GPLv2
URL:            http://raptorv2.sourceforge.net/
Source0:        http://downloads.sourceforge.net/raptorv2/%{name}-%{version}.tar.gz
Source1:        rafkill.desktop
Source2:        rafkill.6
Source3:        rafkill.png
Patch0:         rafkill-1.2.2-shatter-crash.patch
Patch1:         rafkill-1.2.2-gcc43.patch
Patch2:		rafkill-1.2.3-gcc470.patch
Patch3:		rafkill-printf-format.patch
BuildRequires:  liballegro-devel dumb-devel scons desktop-file-utils
Requires:       icon-theme-hicolor

%description
Rafkill is a vertical scrolling shoot-em up game. You can collect powerups
during gameplay and you can goto the store with your spaceship and buy
powerups or even a complete new ship with the points you've earned sofar.


%prep
%setup -q 
%patch0 -p1 -z .shatter
%patch1 -p1 -z .gcc43
%patch2 -p0 -z .gcc470
%patch3 -p0 -z .format
# sigh hack hack hack
FLAGS=""
for i in $RPM_OPT_FLAGS; do
  FLAGS="$FLAGS '$i',"
done
FLAGS="$FLAGS '-DINSTALL_DIR=\\\\\\\\\"%{_datadir}\\\\\\\\\"'"
sed -i "s!flags = .*!flags = [ $FLAGS ];!" SConstruct


%build
scons prefix=%{_datadir}


%install
#scons won't install into a buildroot, only into the real root so DIY
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name} $RPM_BUILD_ROOT%{_bindir}
install -m 755 %{name} $RPM_BUILD_ROOT%{_bindir}
cp -a data music $RPM_BUILD_ROOT%{_datadir}/%{name}
rm $RPM_BUILD_ROOT%{_datadir}/%{name}/*/.sconsign
rm $RPM_BUILD_ROOT%{_datadir}/%{name}/data/*.h

# manpage courtesy of Debian
mkdir -p $RPM_BUILD_ROOT%{_mandir}/man6
install -m 644 %{SOURCE2} $RPM_BUILD_ROOT%{_mandir}/man6 

# below is the desktop file and icon stuff.
mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  %{SOURCE1}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps
install -p -m 644 %{SOURCE3} \
  $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/48x48/apps

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
cat > $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Richard Hughes <richard@hughsie.com> -->
<!--
EmailAddress: kazzmir@users.sf.net
SentUpstream: 2014-09-18
-->
<application>
  <id type="desktop">rafkill.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <description>
    <p>
      Rafkill is a vertical scrolling shoot-em up game. You can collect powerups
      during gameplay and you can goto the store with your spaceship and buy
      powerups or even a complete new ship with the points you've earned sofar.
    </p>
  </description>
  <url type="homepage">http://raptorv2.sourceforge.net/index.php</url>
  <screenshots>
    <screenshot type="default">http://raptorv2.sourceforge.net/images/title.png</screenshot>
    <screenshot>http://raptorv2.sourceforge.net/images/snapshot1.png</screenshot>
    <screenshot>http://raptorv2.sourceforge.net/images/buy.png</screenshot>
  </screenshots>
  <updatecontact>kazzmir@users.sf.net</updatecontact>
</application>
EOF

%files
%doc README COPYING
%{_bindir}/%{name}
%{_datadir}/%{name}
%{_mandir}/man6/%{name}.6*
%{_datadir}/appdata/%{name}.appdata.xml
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/48x48/apps/%{name}.png


%changelog
