Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# $Id: rblcheck.spec,v 1.16 2005/07/01 10:41:31 oliver Exp $

Name:		rblcheck
Summary:	Command-line interface to RBL-style listings

Version:	1.5
Release:	alt2_46

Source0:	https://github.com/logic/rblcheck/releases/download/%{name}-%{version}/%{name}-%{version}.tar.gz
Source1:	rblcheckrc

License:	GPLv2+
URL:		https://github.com/logic/rblcheck


# Change the text "RBL filtered by" to "listed by"
# (RBL is a trademark of MAPS LLC.)
# 'listed by' is more accurate
Patch0:		rblcheck-texttweak.patch

# Fix broken code for looking up TXT records, code borrowed
# from Ian Gulliver's "firedns" library (GPL), which can be found at:
# http://firestuff.org/
Patch1:		rblcheck-txt.patch

# Comes from a post to the rblcheck users mailing list. See:
# http://sourceforge.net/mailarchive/forum.php?thread_id=1371771&forum_id=4256
Patch2:		rblcheck-names.patch

# Compile fix for x86_64 systems
Patch3:		rblcheck-1.5-res_query.patch

Patch4:		rblcheck-configure-c99.patch

BuildRequires:	docbook-utils, gcc
Source44: import.info

%description
rblcheck is a very basic interface to RBL-style DNS listings such as those
operated by the MAPS (http://www.mail-abuse.org/) and ORBL
(http://www.orbl.org/) projects.

%prep
%setup -q

%patch0 -p1 -b .texttweak
%patch1 -p0 -b .txt
%patch2 -p0 -b .names
%patch3 -p1 -b .res_query
%patch4 -p1 -b .c99

%build
%configure
make

%install
%makeinstall

install -D -m644 %{SOURCE1} $RPM_BUILD_ROOT%{_sysconfdir}/rblcheckrc

%files
%doc AUTHORS ChangeLog NEWS README COPYING
%doc docs/rblcheck.ps docs/rblcheck.rtf docs/html/
%{_bindir}/rbl
%{_bindir}/rblcheck
%config(noreplace) %{_sysconfdir}/rblcheckrc

%changelog
