Group: System/Base
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           rcssmonitor
Version:        18.0.0
Release:        alt1_4
Summary:        RoboCup 2D Soccer Simulator Monitor

# rcss/ libraries are under LGPLv2+
License:        GPLv2+ and LGPLv2+
URL:            http://sourceforge.net/projects/sserver/
Source0:        http://downloads.sourceforge.net/sserver/%{name}-%{version}.tar.gz
# Source 1 is created by me.
Source1:        %{name}.desktop
Provides:       rcsslogplayer = %{version}-%{release}
Obsoletes:      rcsslogplayer <= 15.1.1-30

BuildRequires:  gcc-c++ ctest cmake qt5-base-devel desktop-file-utils zlib-devel
Source44: import.info

%description
The RoboCup Soccer Simulator Monitor is a viewer for moved 2d vector graphics.
You can use it to watch 2D soccer games running on rcssserver. However, The
architecture of The RoboCup Soccer Simulator Monitor was from the beginning
kept as general and modular as possible and not just hacked to fit the  needs
of the robocup soccer server (rcssserver). So by now The RoboCup Soccer
Simulator Monitor is also used to visualize many other two dimensional system.

You can use UDP/IP communication sockets to send commands to The RoboCup Soccer
Simulator Monitor. A generic communication device is also included. It
understands a very easy description language to build and move 2d objects.

%package        devel
Group: System/Base
Summary:        Header files and libraries for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
This package contains the header files and libraries
for %{name}. If you like to develop programs using %{name},
you will need to install %{name}-devel.

%prep
%setup -q
sed -i.flagfix "/CMAKE_CXX_FLAGS/d" CMakeLists.txt

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

mkdir -p %{buildroot}/%{_datadir}/pixmaps/
cp -p icons/rcss.xpm %{buildroot}/%{_datadir}/pixmaps/

desktop-file-install \
  --dir=%{buildroot}/%{_datadir}/applications %{SOURCE1}

%files
%doc --no-dereference COPYING
%doc AUTHORS ChangeLog NEWS README.md
%{_bindir}/*
%{_libdir}/*.so.*
%{_datadir}/pixmaps/*
%{_datadir}/applications/*

%files devel
%{_includedir}/*
%{_libdir}/*.so

%changelog
