Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           redir
Version:        3.3
Release:        alt1_9
Summary:        A TCP port redirector for UNIX

License:        GPLv2+
URL:            https://github.com/troglobit/redir
Source0:        https://github.com/troglobit/%{name}/archive/v%{version}/%{name}-%{version}.tar.gz

BuildRequires:  gcc
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  gettext-tools
Source44: import.info

%description
This is a TCP port redirector for UNIX. It can be run under inetd or as 
standalone (in which case it handles multiple connections). It is 8 bit 
clean, not limited to line mode, is small and lightweight. If you want 
access control, run it under xinetd, or inetd with TCP wrappers.
Redir listens for TCP connections on a given port, and, when it receives 
a connection, then connects to a given destination address:port, and 
pass data between them. It finds most of its applications in traversing 
firewalls, but, of course, there are other uses.

%prep
%setup -q


%build
./autogen.sh
%configure
%make_build CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="$RPM_OPT_FLAGS"

%check
make check

%install
%makeinstall_std

%files
%doc --no-dereference COPYING
%doc COPYING TODO
%{_bindir}/%{name}
%{_docdir}/%{name}/*
%{_mandir}/man1/%{name}.1*

%changelog
