Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Usage.pm) perl(Term/ANSIColor.pm) perl-podlators
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		renrot
Version:	1.2.0
Release:	alt2_23
Summary:	A program to rename and rotate files according to EXIF tags

License:	Artistic 2.0	  
URL:		http://puszcza.gnu.org.ua/projects/renrot/
Source0:	ftp://download.gnu.org.ua/pub/release/renrot/%{name}-%{version}.tar.gz

BuildArch:	noarch
BuildRequires:	perl-devel
BuildRequires:	rpm-build-perl
BuildRequires:	perl(ExtUtils/MakeMaker.pm)
BuildRequires:	perl(Image/ExifTool.pm)
BuildRequires:	perl(Getopt/Long.pm)
Requires:	/usr/bin/jpegtran
%if 0%{?fedora}
Requires:	perl(Image/Magick.pm)
%endif


Source44: import.info

%description
Renrot renames files according the DateTimeOriginal and FileModifyDate
EXIF tags, if they exist. Otherwise, the name will be set according to
the current timestamp. Additionally, it rotates files and their
thumbnails, accordingly Orientation EXIF tag.

The script can also put commentary into the Commentary and UserComment
tags.

Personal details can be specified via XMP tags defined in a
configuration file.


%prep
%setup -q



%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'
find $RPM_BUILD_ROOT -depth -type d -exec rmdir {} 2>/dev/null ';'
# %{_fixperms} $RPM_BUILD_ROOT/*

# Fix shbang
sed -i 's|#!/usr/bin/env perl|#!/usr/bin/perl|' $RPM_BUILD_ROOT%{_bindir}/renrot

# install sample configuration files
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
install -m644 etc/colors.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
install -m644 etc/copyright.tag $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
install -m644 etc/renrot.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}
install -m644 etc/tags.conf $RPM_BUILD_ROOT%{_sysconfdir}/%{name}


%check
make test


%files
%doc AUTHORS README ChangeLog NEWS TODO
%lang(ru) %doc README.russian
%{perl_vendor_privlib}/*
%{_bindir}/renrot
%{_mandir}/man1/*.1*
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/colors.conf
%config(noreplace) %{_sysconfdir}/%{name}/copyright.tag
%config(noreplace) %{_sysconfdir}/%{name}/renrot.conf
%config(noreplace) %{_sysconfdir}/%{name}/tags.conf


%changelog
