# BEGIN SourceDeps(oneline):
BuildRequires: /dev/pts /proc
# END SourceDeps(oneline)
Group: File tools
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%if 0%{?fedora}
%bcond_with tests
%else
%bcond_with tests
%endif
%global commit0 f2a60ce3f9ac3a96140472cd1e1e71a448d42293
Name:           reptyr
Version:        0.8.0
Release:        alt1_3
Summary:        Attach a running process to a new terminal

License:        MIT
URL:            http://github.com/nelhage/reptyr
Source0:        https://github.com/nelhage/reptyr/archive/%{name}-%{version}.tar.gz
ExclusiveArch:  %{ix86} x86_64 %{arm}
%if %{with tests}
Requires: pkg-config
BuildRequires:  gcc
BuildRequires:  %{_bindir}/python3
BuildRequires:  python3-module-pexpect
# https://github.com/nelhage/reptyr/issues/69
BuildRequires:  rdma-core-devel >= 3.4
%endif
Source44: import.info

%description
reptyr is a utility for taking an existing running program and
attaching it to a new terminal.  Started a long-running process over
ssh, but have to leave and don't want to interrupt it?  Just start a
screen, use reptyr to grab it, and then kill the ssh session and head
on home.


%prep
%setup -q -n %{name}-%{name}-%{version}
sed -i s/python2/python3/g Makefile

%build
%make_build CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="$RPM_LD_FLAGS"

%install
make install PREFIX="%{_prefix}" DESTDIR="$RPM_BUILD_ROOT"
%find_lang %{name} --with-man


%if %{with tests}
%check
make test CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="$RPM_LD_FLAGS"
%endif



%files -f %{name}.lang
%define bashcomp %(pkg-config --variable=completionsdir bash-completion)
%if "%{bashcomp}" == "%{nil}"
%define bashcomp /etc/bash_completion.d
%endif

%{!?_licensedir:%global license %%doc}
%doc --no-dereference COPYING
%doc ChangeLog NOTES README.md
%{_bindir}/reptyr
%{_mandir}/man1/reptyr.1*
%{bashcomp}/reptyr

%changelog
