Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3
BuildRequires: python-devel
# END SourceDeps(oneline)
%define fedora 34
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global srcname resalloc-openstack
%global pkgname resalloc_openstack

%if 0%{?fedora} || 0%{?rhel} > 7
%bcond_with python2
%global default_sitelib %python3_sitelibdir_noarch
%global python python3
%global pythonpfx python3
%else
%bcond_without python2
%global default_sitelib %python_sitelibdir_noarch
%global python python2
%global pythonpfx python
%endif

Name:       %srcname
Summary:    Resource allocator scripts for OpenStack
Version:    8
Release:    alt1_4
License:    GPLv2+
URL:        https://github.com/praiskup/resalloc-openstack
BuildArch:  noarch


BuildRequires: python3-devel
BuildRequires: python3-module-pkg_resources python3-module-setuptools

Requires: python3-module-cinderclient
Requires: python3-module-glanceclient
Requires: python3-module-keystoneauth1
Requires: python3-module-neutronclient
Requires: python3-module-novaclient

Source0: https://github.com/praiskup/%name/releases/download/v%version/%name-%version.tar.gz
Source44: import.info

%description
Resource allocator spawner/terminator scripts for OpenStack virtual machines,
designed so they either allocate all the sub-resources, or nothing (in case of
some failure).  This is especially useful if working with older OpenStack
deployments which all the time keep orphaned servers, floating IPs, volumes,
etc. dangling around.

These scripts are primarily designed to be used with resalloc-server.rpm, but in
general might be used separately.


%prep
%setup -q


%build
%if %{with python2}
%python_build
%else
%python3_build
%endif


%install
%if %{with python2}
%python_install
%else
%python3_install
%endif


%files
%doc --no-dereference COPYING
%doc README
%{_bindir}/%{name}-*
%_mandir/man1/%{name}-*.1*
%{default_sitelib}/%{pkgname}
%{default_sitelib}/%{pkgname}-*.egg-info


%changelog
