Group: Archiving/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# No debugging info because the built .exe is bytecode. Re-enable
# if we get AOT working.
%global debug_package %{nil}

Name:           rescene
Version:        1.2
Release:        alt2_30
Summary:        Extracts RAR metadata and recreates RAR files
License:        MIT
# Upstream at http://rescene.info/ appears to have gone away. Mirror is
# maintained at:
URL:            http://rescene.wikidot.com/
Source0:        http://rescene.wdfiles.com/local--files/downloads/srr.%{version}.cs.zip

BuildRequires:  mono-core mono-data mono-data-sqlite mono-devel mono-extras mono-wcf mono-web
Requires:       mono-core mono-data mono-data-sqlite mono-extras mono-wcf mono-web
ExclusiveArch:  %{mono_arches}
Source44: import.info

%description
ReScene is a mechanism for backing up and restoring the metadata from
RAR archives.


%prep
%setup -q -c
cat >rescene.shell_script <<EOS
#!/bin/sh

mono "%{_libdir}/%{name}/srr.exe" "\$@"
EOS

# Fix EOL encodings
sed -i -e "s|\r||" license.txt



%build
mcs -unsafe -out:srr.exe *.cs

# Enabling AOT compilation causes rpmbuild to fail generating debuginfo.
# Disable it for now.
#mono --aot -O=all rescene.exe


%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_libdir}/%{name}

install -m 755 srr.exe $RPM_BUILD_ROOT%{_libdir}/%{name}/
# Enabling AOT compilation causes rpmbuild to fail generating debuginfo.
# Disable it for now.
#install -m 755 rescene.exe.so $RPM_BUILD_ROOT%%{_libdir}/%%{name}/
install -m 755 rescene.shell_script $RPM_BUILD_ROOT%{_bindir}/srr



%files
%doc license.txt
%{_libdir}/%{name}
%{_bindir}/srr


%changelog
