AutoReq: yes,nopython
AutoProv: yes,nopython
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 3.0.1
%global urlver	%(echo %{version} | tr . _)

Name:           rogueboxadventures
Version:        3.0.1
Release:        alt2_2
Summary:        Libre hybrid of classical roguelike gameplay and sandbox games
Group:          Games/Adventure
License:        GPLv3+ and CC-BY 3.0 and CC0 and OFL 1.1
URL:            https://rogueboxadventures.tuxfamily.org
# https://gitgud.io/themightyglider/RogueBoxAdventures
Source0:        https://download.tuxfamily.org/rba/RogueBoxAdventures_v%{urlver}_Source.zip

BuildArch:      noarch
BuildRequires:  python3 python3-tools
Requires:       python3-module-pygame
Source44: import.info

%description
RogueBox Adventures is a free (as in freedom) hybrid between classical
roguelike gameplay and sandbox games. Features:

- A fully procedural generated game world
- Easy to access (lightweight, easy to learn, keyboard, mouse and gamepad)
- Almost infinite possibilities (building, agriculture, crafting)
- Pixel art graphics

%prep
%setup -q -n RogueBoxAdventures_v%{urlver}_Source


%build
# Nothing to do

%install
# First install everything, it's 99% game data
install -d %{buildroot}%{_gamesdatadir}/%{name}
cp -a * %{buildroot}%{_gamesdatadir}/%{name}

# Remove unneeded files
pushd %{buildroot}%{_gamesdatadir}/%{name}
rm -f default.gcw0.desktop icon_big.png LIB/run_gcw0.sh README.md
rm -rf DOC LICENSE SAVE
popd

# Launcher
cat << EOF > %{name}.sh
#!/bin/sh
cd %{_gamesdatadir}/%{name}
%{__python3} main.py -h \$@
EOF
install -D -m755 %{name}.sh %{buildroot}%{_gamesbindir}/%{name}

# Icons
install -D -m644 icon_big.png %{buildroot}%{_datadir}/icons/hicolor/256x256/apps/%{name}.png
install -D -m644 icon_small.png %{buildroot}%{_datadir}/icons/hicolor/32x32/apps/%{name}.png

# Desktop file
install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=RogueBox Adventures
Comment=Libre hybrid of classical roguelike gameplay and sandbox games
GenericName=Roguelike and sandbox game
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Game;RolePlaying;
EOF

%files
%doc DOC/arguments README.md
%doc --no-dereference LICENSE/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.png
%{_gamesbindir}/%{name}
%{_gamesdatadir}/%{name}/


%changelog
