Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global        debug_package %{nil}

Summary:       Realtime IRQ thread system tuning
Name:          rtirq
Version:       20130402
Release:       alt3_25
License:       GPLv2+
URL:           http://www.rncbc.org/jack/
Source0:       http://www.rncbc.org/jack/%{name}-%{version}.tar.gz
# sources for udev and power management additions
Source1:       rtirq-udev
Source2:       rtirq-udev-rules
Source3:       rtirq-power
# add configuration option for a minimum priority in rtirq script
Patch0:        rtirq-minprio.patch
# patch to add udev options to rtirq configuration
Patch1:        rtirq-udevprio.patch
BuildArch:     noarch
BuildRequires: perl-devel
# For systemd.macros
BuildRequires: libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Requires:      systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info

%description
Start-up scripts for tuning the realtime scheduling policy and priority
of relevant IRQ service threads, featured for a realtime-preempt enabled
kernel configuration. 

%prep
%setup -q
%patch1 -p0
# Fix encoding issues
for file in LICENSE; do
   sed 's|\r||' $file > $file.tmp
   iconv -f ISO-8859-1 -t UTF8 $file.tmp > $file.tmp2
   touch -r $file $file.tmp2
   mv -f $file.tmp2 $file
done

sed -i 's,egrep,grep -E,g' %{SOURCE1} %{SOURCE3}

%build

%install
install -D rtirq.sh   -m 0755 %{buildroot}%{_bindir}/rtirq
install -D rtirq.conf -m 0644 %{buildroot}%{_sysconfdir}/sysconfig/rtirq

# fix order of interrupts, tac was reversing the priority of the soundcards
perl -p -i -e "s/\| tac//g" %{buildroot}%{_bindir}/rtirq

# high priority is 70 instead of 90 (in Fedora 17+)
perl -p -i -e "s|RTIRQ_PRIO_HIGH=90|RTIRQ_PRIO_HIGH=70|g" %{buildroot}%{_sysconfdir}/sysconfig/rtirq
# low priority is 65, 5 above Jack highest priority thread
perl -p -i -e "s|RTIRQ_PRIO_LOW=51|RTIRQ_PRIO_LOW=65|g" %{buildroot}%{_sysconfdir}/sysconfig/rtirq
# priority decrement now 1 instead of 5, no need to leave vacant priorities
perl -p -i -e "s|RTIRQ_PRIO_DECR=5|RTIRQ_PRIO_DECR=1|g" %{buildroot}%{_sysconfdir}/sysconfig/rtirq
# remove usb from list of cards in configuration, this is now handled through udev rules
perl -p -i -e "s|rtc snd usb i8042|rtc snd i8042|g" %{buildroot}%{_sysconfdir}/sysconfig/rtirq
# adjust priority for udev changes, same as highest priority
perl -p -i -e "s|RTIRQ_PRIO_UDEV=85|RTIRQ_PRIO_UDEV=70|g" %{buildroot}%{_sysconfdir}/sysconfig/rtirq
# moved out of init.d/
perl -p -i -e "s|/etc/init.d/|%{_bindir}/|g" rtirq.service

# install udev and power files
install -D %{SOURCE2} -m 0644 %{buildroot}%{_udevrulesdir}/95-rtirq.rules
install -D %{SOURCE1} -m 0755 %{buildroot}%{_bindir}/rtirq-udev
install -D %{SOURCE3} -m 0755 %{buildroot}%{_sysconfdir}/pm/sleep.d/05-rtirq
install -vD rtirq.service -m 0644 %{buildroot}%{_prefix}/lib/systemd/system/rtirq.service

%post
%post_service rtirq

%preun
%preun_service rtirq

%files
%doc LICENSE
%config(noreplace) %{_sysconfdir}/sysconfig/rtirq
# udev and power management
%{_udevrulesdir}/95-rtirq.rules
%{_sysconfdir}/pm/sleep.d/05-rtirq
%{_bindir}/rtirq-udev
%{_bindir}/rtirq
%{_prefix}/lib/systemd/system/rtirq.service

%changelog
