# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
# END SourceDeps(oneline)
# sitelib for noarch packages, sitearch for others (remove the unneeded one)
%{!?python_sitelib: %define python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib()")} 

Name: rubber
Version: 1.1
Release: alt1_18
Summary: An automated system for building LaTeX documents

Group: Publishing
License: GPL+

URL: https://launchpad.net/rubber
Source0: https://launchpad.net/rubber/trunk/1.1/+download/%{name}-%{version}.tar.gz
Patch0: rubber-python26.patch
Patch1: rubber-1.1-spaces.patch
BuildArch: noarch
BuildRequires: python-devel texinfo
Requires: /usr/bin/latex texlive-latex-recommended
Source44: import.info


%description
This is a building system for LaTeX documents. It is based on a routine that
runs just as many compilations as necessary. The module system provides a
great flexibility that virtually allows support for any package with no user
intervention, as well as pre- and post-processing of the document. The
standard modules currently provide support for bibtex, dvips, dvipdfm, pdftex,
makeindex. A good number of standard packages are supported, including
graphics/graphicx (with automatic conversion between various formats and
Metapost compilation).

%prep
%setup -q
%patch0 -p1
%patch1 -p1
for file in doc/man-fr/*; do
iconv -f ISO88591 -t utf8 $file -o $file
done

%build
%configure
make %{?_smp_mflags}

%install
%{__python} setup.py install --root  %{buildroot}
rm  %{buildroot}/usr/share/rubber/modules/etex.rub

%files
%doc COPYING NEWS README
%{_bindir}/*
%{_datadir}/rubber
%{_datadir}/info/*
%{python_sitelibdir_noarch}/*
%{_mandir}/man1/**
%{_mandir}/fr/man1/**

%changelog
