# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define build_plf 0
%{?_with_plf: %global build_plf 1}

%define tiff22pnm_version 2014-01-09

# enablelzw = 0 (don't build with LZW compression support)
# enablelzw = 1 (build with LZW compression support)
# Currently we use enablelzw = 0 due to Unisys LZW patents.
%define enablelzw       0

%if %build_plf
%define enablelzw       1
%endif

Summary:	Convert raster images to PostScript or PDF
Name:		sam2p
Version:	0.49.3
Release:	alt1_6
License:	GPLv2+
Source0:	https://github.com/pts/sam2p/releases/download/v0.49.3/%{name}-%{version}.tar.gz
Source1:	https://github.com/pts/tif22pnm/archive/%{tiff22pnm_version}.tar.gz
# (tv) fix linking:
Patch0:		fix-linking.diff
Patch1:		sam2p-0.49.2-mga-deps.diff
Patch2:		sam2p-0.49.2-gcc7.patch
Patch3:		sam2p-0.49.2-perl-5.26.patch
Patch4:		CVE-2017-14636.patch
Patch5:		CVE-2017-14637.patch
Patch6:		CVE-2017-14628.patch
Patch7:		CVE-2017-14630.patch
Patch8:		CVE-2017-14631.patch
Patch9:		CVE-2017-14629.patch
Patch10:	CVE-2017-16663.patch
Patch11:	CVE-2018-7551.patch
Patch12:	CVE-2018-7554.patch
Patch13:	CVE-2018-7487.patch
Patch14:	CVE-2018-7553.patch
Patch15:	CVE-2018-12578.patch
Patch16:	CVE-2018-12601.patch
URL:		https://github.com/pts/sam2p
Group:		Publishing
Requires:	ghostscript
Requires:	libjpeg-utils
BuildRequires:	libjpeg-utils
Requires:	netpbm
BuildRequires:	libtiff-devel libtiffxx-devel
BuildRequires:	pkgconfig(libpng16)
Source44: import.info

%description
sam2p is a UNIX command line utility written in ANSI C++ that converts
many raster (bitmap) image formats into Adobe PostScript or PDF files
and several other formats. The images are not vectorized. sam2p gives
full control to the user to specify standards-compliance, compression,
and bit depths. In some cases sam2p can compress an image 100 times
smaller than the PostScript output of many other common image
converters. sam2p provides ZIP, RLE and LZW (de)compression filters
even on Level1 devices.

%prep
%setup -q -n %{name}-%{version} -a 1
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1


%build
autoconf -f
pushd tif22pnm-%{tiff22pnm_version}
autoconf -f
# Abuse CPPFLAGS to hold our CFLAGS since it's the only way
%configure \
	--with-libtiff-idir=%{_includedir} \
	--with-libpng-idir=%{_includedir}/libpng16 \
	--with-libtiff-ldir=%{_libdir} \
	--with-libpng-ldir=%{_libdir} \
    --enable-debug=yes \
    CPPFLAGS="$CFLAGS"
make
cp tif22pnm png22pnm ../
cp -p README ../README.tif22pnm
popd

%configure \
%if %build_plf
	--enable-lzw \
	--enable-gif
%endif

%make_build CXXFLAGS="$CXXFLAGS" LDXX=g++ ENABLE_DEBUG=yes GFLAG=-DNDEBUG


%install
mkdir -p $RPM_BUILD_ROOT%{_bindir}
install -m 755 sam2p tif22pnm png22pnm $RPM_BUILD_ROOT%{_bindir}

%files
%doc COPYING
%doc README README.tif22pnm examples contrib
%{_bindir}/sam2p
%{_bindir}/tif22pnm
%{_bindir}/png22pnm


%changelog
