# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           saoimage
Version:        1.35.1
Release:        alt1_12
Summary:        Utility for displaying astronomical images

Group:          Sciences/Astronomy
License:        LGPLv2+
URL:            http://tdc-www.harvard.edu/software/saoimage/
Source0:        http://tdc-www.harvard.edu/software/saoimage/%{name}-%{version}.tar.gz
Source1:        saoimage.desktop
Source2:        saoimage.xml
Source3:        saoimage.png
Patch0:         saoimage-1.35.1-decls.patch
Patch1:         saoimage-1.35.1-pad.patch
Patch2:         saoimage-1.35.1-mkstemp.patch
Patch3:         saoimage-1.35.1-inc.patch
Patch4:         saoimage-1.35.1-bpp.patch
Patch5:         saoimage-1.35.1-security.patch

BuildRequires:  pkgconfig(x11)
# Need dist for dehypht-x-2012-05-30.tex
BuildRequires:  texlive-dist
BuildRequires:  doxygen
BuildRequires:  desktop-file-utils
Source44: import.info

%description
SAOimage (pronounced S-A-0-image) is a utility for displaying astronomical
images in the X11 window environment. It was written at the Smithsonian
Astrophysical Observatory by Mike Van Hilst in 1990 and is now maintained
by Doug Mink.

Image files can be read directly, or image data may be passed through a
named pipe (Unix) or a mailbox (VMS) from IRAF display tasks. SAOimage
provides a large selection of options for zooming, panning, scaling,
coloring, pixel readback, display blinking, and region specification.
User interactions are generally performed with the mouse. Mouse tracking in
an image's world coordinate system, usually sky coordinates, was added in
1994. You can also plot catalogs over images with WCS information in their
headers.

The SAOimage desktop includes, a main image display window, a button menu
panel, a display magnifier, a pan and zoom reference image, and a color bar.
A color table graph window can be brought up by clicking on the color bar. 


%prep
%setup -q
%patch0 -p1 -b .decls
%patch1 -p1 -b .pad
%patch2 -p1 -b .mkstemp
%patch3 -p1 -b .inc
%patch4 -p1 -b .bpp
%patch5 -p1 -b .security


%build
%make_build OFLAGS="%{optflags} -fcommon" linux \
        IMTOOLRC=%{_sysconfdir}/imtoolrc

cd doc
rm -f m*.toc
# Build twice to generate TOC
pdflatex manual.tex; pdflatex manual.tex
pdflatex scale.tex

%install
install -d %{buildroot}/%{_bindir}/
install -d %{buildroot}/%{_datadir}/applications
install -d %{buildroot}/%{_datadir}/mime/packages
install -d %{buildroot}/%{_datadir}/pixmaps
install -d %{buildroot}/%{_mandir}/man1/

%make_build -f makefile.linux install_saobin install_saoman    \
        ROOT=%{buildroot}/                            \
        SAOBINDIR=%{buildroot}/%{_bindir}/            \
        SAOMANDIR=%{buildroot}/%{_mandir}/man1/

desktop-file-install %{SOURCE1}         \
        --dir=%{buildroot}/%{_datadir}/applications

install -pm 0644 %{SOURCE2} %{buildroot}/%{_datadir}/mime/packages
install -pm 0644 %{SOURCE3} %{buildroot}/%{_datadir}/pixmaps

%files
%{_bindir}/saoimage
%{_datadir}/mime/*
%{_datadir}/applications/*
%{_datadir}/pixmaps/*
%{_mandir}/man1/saoimage.1*
%doc README NEWS COPYING
%doc doc/*.txt doc/*.pdf wcssubs-3.5.1/COPYING



%changelog
