# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name sblim-sfcc
%define libcimcClientXML_major 0
%define libcimcClientXML libcimcClientXML%{libcimcClientXML_major}

%define libcimcclient_major 0
%define libcimcclient libcimcclient%{libcimcclient_major}

%define libcmpisfcc_major 1
%define libcmpisfcc libcmpisfcc%{libcmpisfcc_major}

%define develname lib%{name}-devel

Name:           sblim-sfcc
Version:        2.2.8
Release:        alt1_7
Summary:        Standards Based Linux Instrumentation for Manageability
Group:          Development/C
License:        CPL and EPL
URL:            https://sourceforge.net/projects/sblim/
Source0:        https://sourceforge.net/projects/sblim/files/sblim-sfcc/%{name}-%{version}.tar.bz2

BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(openssl)
Source44: import.info

%description
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%package -n %{develname}
Group: Development/C
Summary:        Standards Based Linux Instrumentation for Manageability
Provides:       sfcc-devel = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Requires:       %{libcimcClientXML} = %{version}-%{release}
Requires:       %{libcimcclient} = %{version}-%{release}
Requires:       %{libcmpisfcc} = %{version}-%{release}
Requires:     %{name}-docs = %{version}-%{release}

%description -n %{develname}
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%package -n %{libcimcClientXML}
Group: Development/C
Summary:        Standards Based Linux Instrumentation for Manageability
#Obsoletes:      %{_lib}cimcClientXML0 < 2.2.8-3

%description -n %{libcimcClientXML}
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%package -n %{libcimcclient}
Group: Development/C
Summary:        Standards Based Linux Instrumentation for Manageability

%description -n %{libcimcclient}
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%package -n %{libcmpisfcc}
Group: Development/C
Summary:        Standards Based Linux Instrumentation for Manageability

%description -n %{libcmpisfcc}
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%package -n %{name}-docs
Group: Development/C
Summary:        Standards Based Linux Instrumentation for Manageability

%description -n %{name}-docs
SBLIM (pronounced "sublime"), the Standards Based Linux Instrumentation for
Manageability is an IBM-initiated Open Source project, intended to enhance
the manageability of GNU/Linux systems. It does so by enabling WBEM, Web
Based Enterprise Management.

%prep
%setup -q


# make autoreconf more happy
sed -i -e 's,AM_INIT_AUTOMAKE.*,AM_INIT_AUTOMAKE(\[subdir-objects\]),' configure.ac

%build
# fix build on aarch64
autoreconf -vfi

%configure
%make_build

%install
%makeinstall_std

find %{buildroot} -name "*.*a" -delete

%files -n %{develname}
%{_includedir}/CimClientLib/*.h
%{_includedir}/cimc/*.h
%{_libdir}/*.so

%files -n %{libcimcClientXML}
%{_libdir}/libcimcClientXML.so.%{libcimcClientXML_major}
%{_libdir}/libcimcClientXML.so.%{libcimcClientXML_major}.*

%files -n %{libcimcclient}
%{_libdir}/libcimcclient.so.%{libcimcclient_major}
%{_libdir}/libcimcclient.so.%{libcimcclient_major}.*

%files -n %{libcmpisfcc}
%{_libdir}/libcmpisfcc.so.%{libcmpisfcc_major}
%{_libdir}/libcmpisfcc.so.%{libcmpisfcc_major}.*

%files -n %{name}-docs
%{_datadir}/doc/sfcc-%{version}/AUTHORS
%{_datadir}/doc/sfcc-%{version}/COPYING
%{_datadir}/doc/sfcc-%{version}/README
%{_mandir}/man3/*


%changelog
