Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install imake libICE-devel libSM-devel libX11-devel libalsa-devel libflac-devel libopenmotif-devel python3-devel xorg-cf-files
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:      schismtracker
Version:   20240308
Release:   alt1_1
Summary:   Sound module composer/player
License:   GPLv2
URL:       http://schismtracker.org/
Source0:   https://github.com/schismtracker/schismtracker/archive/%{version}.tar.gz
Source1:   schismtracker.desktop
Excludearch:   s390x
Requires:      icon-theme-hicolor
BuildRequires: autoconf
BuildRequires: automake
BuildRequires: gcc
BuildRequires: libSDL2-devel libSDL2-devel-static
BuildRequires: desktop-file-utils
BuildRequires: python3
%if 0%{!?_without_x:1}
BuildRequires: libXt-devel
BuildRequires: libXv-devel
%endif
Source44: import.info

%description
Schismtracker is a module tracker for the X Window System similar to
the DOS program `Impulse Tracker'. Schismtracker can play/modify various
sound formats such as MOD, S3M, XM, IT, 669 and others.  The user interface
is mostly text-based using SDL for graphical output.

%prep
%setup -q
mkdir auto

%build
autoreconf -i
%configure --disable-dependency-tracking \
%if 0%{?_without_x:1}
--with-x=no \
%endif
;
%make_build

%install
make install DESTDIR=%{buildroot}

pushd icons
for i in 16 22 24 32 36 48 64 72 96; do
        install -m644 -D schism-icon-${i}.png %{buildroot}/%{_datadir}/icons/hicolor/${i}x${i}/apps/%{name}.png
done
install -m644 -D schism-icon.svg %{buildroot}/%{_datadir}/icons/hicolor/scalable/apps/%{name}.svg
popd

desktop-file-install \
--dir %{buildroot}/%{_datadir}/applications \
%SOURCE1

%files
%doc AUTHORS COPYING NEWS
%{_bindir}/schismtracker
%{_datadir}/applications/schismtracker.desktop
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%{_mandir}/man1/%{name}.1*
%{_datadir}/applications/schism.desktop
%{_datadir}/pixmaps/schism*.png

%changelog
