# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: /usr/bin/2to3 /usr/bin/git gcc-c++ perl(IO/Handle.pm) perl(XML/XPath.pm) unzip
# END SourceDeps(oneline)
%add_findreq_skiplist /usr/share/scid/tcl/*
%add_findreq_skiplist /usr/bin/*
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	Shane's Chess Information Database
Name:		scid
Version:	4.7.0
%define major     %(echo %{version}|cut -d. -f1,2)
Release:	alt1_3
Group:		Games/Boards
License:	GPLv2+
Source0:	https://downloads.sourceforge.net/project/scid/Scid/Scid%%20%{major}/%{name}-code-%{version}.zip
Source1:	%{name}.png
Patch0:		scid-4.6.2-mga-paths.patch
Patch1:		scid-4.7.0-mga-gtest.patch
Patch2:		scid-4.7.0-mga-installdir.patch
Patch3:		scid-4.7.0-mga-tests.patch
URL:		http://scid.sourceforge.net
BuildRequires:	cmake
BuildRequires:	tcl-devel
BuildRequires:	tk-devel
BuildRequires:	pkgconfig(gtest)
BuildRequires:	python3-devel
Requires:	nail
Requires:	tcl-snack
Conflicts:	scidvspc
Source44: import.info

%description
Scid (Shane's Chess Information Database) is a free chess database app.

With Scid you can maintain a database of chess games, search games by
many criteria, view graphical trends, and produce printable reports on
players and openings.

You can also analyze games with the Xboard or UCI compatible chess
program, and even use Scid to study endings with endgame tablebases.

With Scid you can also play against various engines, or on the Internet.

%prep
%setup -q -n %{name}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
2to3 --no-diffs -w scripts
sed -i -e '1s/python$/python3/' scripts/*.py
sed -i -E -e 's/string\.(strip|lower)\((.*)\)/\2.\1()/' scripts/*.py
sed -i -E -e 's/string\.join\(([^,]*), *([^)]*)\)/\2.join(\1)/' scripts/*.py
%{mageia_cmake} -DGTEST=ON
%mageia_cmake_build
%make_build -C engines/togaII1.2.1a/src CXXFLAGS="$CXXFLAGS" LDFLAGS="$LDFLAGS" 

%check
build/gtest/scid_tests

%install
%mageia_cmake_install

install -m0755 -D engines/togaII1.2.1a/src/togaII %{buildroot}%{_bindir}/togaII
mkdir -p %{buildroot}%{_datadir}/%{name}/bases
cp scid*.eco %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_iconsdir}/hicolor/128x128/apps
cp %{SOURCE1} %{buildroot}%{_iconsdir}/hicolor/128x128/apps

mkdir -p %{buildroot}%{_datadir}/applications
cat > %{buildroot}%{_datadir}/applications/%{name}.desktop << EOF
[Desktop Entry]
Name=Scid
Comment=Chess games database
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
StartupNotify=true
Categories=BoardGame;Game;
EOF

%files
%{_bindir}/*
%{_datadir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/*/*/*/%{name}.*
%doc ChangeLog TODO bitmaps/ help/
%doc --no-dereference COPYING


%changelog
