Group: System/Servers
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           sec
Version:        2.9.2
Release:        alt1_3
Summary:        Simple Event Correlator script to filter log file entries
License:        GPLv2+
URL:            https://simple-evcorr.github.io/
Source0:        https://github.com/simple-evcorr/sec/releases/download/%{version}/sec-%{version}.tar.gz
Source1:        sec.service
Source2:        sec@.service
Source3:        sec.logrotate
Source4:        sec.sysconfig
Source5:        conf.README
BuildArch:      noarch

BuildRequires:  rpm-build-perl
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit

Requires:       logrotate
Source44: import.info


%description
SEC is a simple event correlation tool that reads lines from files, named
pipes, or standard input, and matches the lines with regular expressions,
Perl subroutines, and other patterns for recognizing input events.
Events are then correlated according to the rules in configuration files,
producing output events by executing user-specified shell commands, by
writing messages to pipes or files, etc.

%prep
%setup -q

%build

%install
# Install SEC and its associated files
install -D -m 0755 -p sec        %{buildroot}%{_bindir}/sec
install -D -m 0644 -p sec.man    %{buildroot}%{_mandir}/man1/sec.1
install -D -m 0644 -p %{SOURCE1} %{buildroot}%{_unitdir}/sec.service
install -D -m 0644 -p %{SOURCE2} %{buildroot}%{_unitdir}/sec@.service
install -D -m 0644 -p %{SOURCE3} %{buildroot}%{_sysconfdir}/logrotate.d/sec
install -D -m 0644 -p %{SOURCE4} %{buildroot}%{_sysconfdir}/sysconfig/sec
install -D -m 0644 -p %{SOURCE5} %{buildroot}%{_sysconfdir}/%{name}/README

# Remove executable bits because these files get packed as docs
chmod 0644 contrib/convert.pl contrib/swatch2sec.pl

%post
%post_service sec

%preun
%preun_service sec

%files
%doc ChangeLog COPYING README contrib/convert.pl contrib/itostream.c contrib/swatch2sec.pl
%config(noreplace) %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/logrotate.d/sec
%config(noreplace) %{_sysconfdir}/sysconfig/sec
%{_bindir}/sec
%{_mandir}/man1/sec.1*
%{_unitdir}/sec.service
%{_unitdir}/sec@.service

%changelog
