# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global hash 72f39d4
%global date 20180715

Name:           sgabios
Epoch:          1
Version:        0.%{date}git
Release:        alt1_1
Summary:        Serial graphics BIOS option rom

Group:          Emulators
License:        ASL 2.0
URL:            https://github.com/qemu/sgabios
# There are no upstream releases.  This archive is prepared as follows:
#
# git clone https://github.com/qemu/sgabios
# cd sgabios
# hash=`git log -1 --format='%h'`
# date=`git log -1 --format='%cd' --date=short | tr -d -`
# git archive --prefix sgabios-${date}-git${hash}/ ${hash} | xz -7e > ../openbios-${date}-git${hash}.tar.xz
Source0:        sgabios-%{date}-git%{hash}.tar.xz

BuildRequires:  binutils-x86_64-linux-gnu 
BuildRequires:  gcc-x86_64-linux-gnu
Buildarch: noarch

Requires: %{name}-bin = %{epoch}:%{version}-%{release}

# Sgabios is noarch, but required on architectures which cannot build it.
# Disable debuginfo because it is of no use to us.
%global debug_package %{nil}
Source44: import.info

%description
SGABIOS is designed to be inserted into a BIOS as an option rom to provide over
a serial port the display and input capabilities normally handled by a VGA
adapter and a keyboard, and additionally provide hooks for logging displayed
characters for later collection after an operating system boots.

%package bin
Group: Emulators
Summary: Sgabios for x86
Buildarch: noarch

%description bin
SGABIOS is designed to be inserted into a BIOS as an option rom to provide over
a serial port the display and input capabilities normally handled by a VGA
adapter and a keyboard, and additionally provide hooks for logging displayed
characters for later collection after an operating system boots.

%prep
%setup -q -n sgabios-%{date}-git%{hash}



%build
unset MAKEFLAGS
make \
        HOSTCC=gcc \
        CC=x86_64-linux-gnu-gcc \
        AS=x86_64-linux-gnu-as \
        LD=x86_64-linux-gnu-ld \
        OBJCOPY=x86_64-linux-gnu-objcopy \
        OBJDUMP=x86_64-linux-gnu-objdump


%install
mkdir -p $RPM_BUILD_ROOT%{_datadir}/sgabios
install -m 0644 sgabios.bin $RPM_BUILD_ROOT%{_datadir}/sgabios


%files
%doc COPYING design.txt


%files bin
%dir %{_datadir}/sgabios/
%{_datadir}/sgabios/sgabios.bin




%changelog
