# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: perl(JSON/PP.pm)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Find commit and version via redirection on https://www.chiark.greenend.org.uk/~sgtatham/puzzles/puzzles.tar.gz
%define commit  91735e5
%define uname   puzzles

Name:           sgt-%{uname}
Version:        20230401
Release:        alt1_1
Summary:        Simon Tatham's one-player puzzle collection
Group:          Games/Puzzles
License:        MIT
URL:            https://www.chiark.greenend.org.uk/~sgtatham/puzzles/
Source0:        https://www.chiark.greenend.org.uk/~sgtatham/puzzles/%{uname}-%{version}.%{commit}.tar.gz
Source1:        template.desktop

BuildRequires:  ccmake cmake ctest
BuildRequires:  ImageMagick-tools
BuildRequires:  pkgconfig(gtk+-3.0)
Source44: import.info

%description
This is a collection of small desktop toys, little games that you can
pop up in a window and play for two or three minutes while you take a
break from whatever else you were doing.

%prep
%setup -q -n %{uname}-%{version}.%{commit}


sed -i 's|share/pixmaps|share/icons/hicolor/48x48/apps|' cmake/platforms/unix.cmake

%build
# FIXME: we should use the %%cmake macros
cmake -B build \
       -DCMAKE_BUILD_TYPE=RelWithDebInfo \
       -DCMAKE_INSTALL_PREFIX=%{_prefix} \
       -DCMAKE_INSTALL_BINDIR=%{_gamesbindir} \
       -DNAME_PREFIX=puzzle-
%mageia_cmake_build

%install
%mageia_cmake_install

# Create a menu subfolder for Simon Tatham's puzzles in the Puzzle folder
mkdir -p %{buildroot}%{_datadir}/desktop-directories
cat > %{buildroot}%{_datadir}/desktop-directories/%{name}.directory <<EOF
[Desktop Entry]
Encoding=UTF-8
Name=Simon Tatham's Puzzles
Icon=puzzle_section
Type=Directory
EOF

mkdir -p %{buildroot}%{_sysconfdir}/xdg/menus/applications-merged
cat > %{buildroot}%{_sysconfdir}/xdg/menus/applications-merged/%{name}.menu <<EOF
<!DOCTYPE Menu PUBLIC "-//freedesktop//DTD Menu 1.0//EN"
"https://www.freedesktop.org/standards/menu-spec/menu-1.0.dtd">
<Menu>
  <Name>Applications</Name>
  <Menu>
    <Name>Games</Name>
    <Menu>
      <Name>Puzzles</Name>
      <Menu>
        <Name>Simon Tatham's Puzzles</Name>
        <Directory>%{name}.directory</Directory>
        <Include>
          <Category>X-SGTatham-Puzzles</Category>
        </Include>
      </Menu>
    </Menu>
  </Menu>
</Menu>
EOF

%files
%doc HACKING puzzles.txt
%doc --no-dereference LICENCE
%{_gamesbindir}/puzzle-*
%{_datadir}/applications/puzzle-*.desktop
%{_datadir}/desktop-directories/%{name}.directory
%{_iconsdir}/hicolor/*/apps/puzzle-*.png
%{_sysconfdir}/xdg/menus/applications-merged/%{name}.menu


%changelog
