Group: Emulators
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           simcoupe
Version:        1.0
Release:        alt2_34
Summary:        SAM Coupe emulator (spectrum compatible)
License:        GPLv2+
URL:            http://www.simcoupe.org
Source0:        http://downloads.sourceforge.net/%{name}/SimCoupe-%{version}.tar.gz
Source1:        B-DOS-License.txt
Patch0:         simcoupe-1.0-userpmopts.patch
Patch1:         simcoupe-1.0-saasound.patch
Patch2:         simcoupe-1.0-no-builtin-rom.patch
BuildRequires:  gcc-c++
BuildRequires:  SAASound-devel libSDL-devel zlib-devel
BuildRequires:  ImageMagick-tools desktop-file-utils
Requires:       samcoupe-rom icon-theme-hicolor
Source44: import.info

%description
SimCoupe emulates an 8bit Z80 based home computer, released in 1989 by Miles
Gordon Technology. The SAM Coupe was largely spectrum compatible, with much
improved hardware


%prep
%setup -q -n SimCoupe
%patch0 -p1
%patch1 -p1
%patch2 -p1
# Clean up bundled SAASound to avoid accidentally building against it.
rm -f Extern/SAASound.h Extern/SAASound.cpp
cp -a %{SOURCE1} .


%build
pushd SDL
%make_build CFLAGSRPM="%{optflags}"
popd

#Build icon image
convert SDL/SimCoupe.bmp -transparent '#ffffff' %{name}.png

#Build desktop icon
cat >%{name}.desktop<<EOF
[Desktop Entry]
Encoding=UTF-8
Name=SimCoupe
GenericName=SAM Coupe Emulator
Comment=%{summary}
Exec=%{name}
Icon=%{name}
Terminal=false
Type=Application
Categories=Game;Emulator;
EOF


%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_datadir}/%{name}
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/32x32/apps
install -pm 0755 SDL/%{name} %{buildroot}%{_bindir}
install -pm 0644 SDL/SimCoupe.bmp %{buildroot}%{_datadir}/%{name}
install -pm 0644 %{name}.png %{buildroot}%{_datadir}/icons/hicolor/32x32/apps

desktop-file-install \
%if 0%{?fedora} && 0%{?fedora} < 19
    --vendor fedora \
%endif
    --dir %{buildroot}%{_datadir}/applications \
    %{name}.desktop


%files
%doc ChangeLog.txt License.txt SimCoupe.txt B-DOS-License.txt
%{_bindir}/%{name}
%if 0%{?fedora} && 0%{?fedora} < 19
%{_datadir}/applications/fedora-%{name}.desktop
%else
%{_datadir}/applications/%{name}.desktop
%endif
%{_datadir}/icons/hicolor/32x32/apps/%{name}.png
%{_datadir}/%{name}


%changelog
