# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define pkgname Sjeng-Free
%add_optflags -fcommon

Name:           sjeng-free
Version:        11.2
Release:        alt1_21
Summary:        Chess program that plays many variants
License:        GPLv2
Group:          Games/Boards

URL:		http://sjeng.sourceforge.net/
Source0:	https://prdownloads.sourceforge.net/sjeng/%{pkgname}-%{version}.tar.bz2
Source1:	sjeng.6.bz2
Source2:	sjeng-README.bz2

Patch0:		sjeng-11.2-cleanup.patch
Patch1:		sjeng-11.2-fhs.patch
Patch2:         sjeng-11.2-mga-fix-build-with-automake-1.13.patch

BuildRequires:	libgdbm-devel
Source44: import.info

%description
Sjeng is a chess program that plays normal chess and many variants
like crazyhouse, bughouse, suicide (aka giveaway or anti-chess) and
losers. It can also play variants which have the same rules as normal
chess, but a different starting position. It uses the XBoard/WinBoard
interface by Tim Mann, so it can be used with xboard or eboard. It
is also capable of playing on internet chess servers.

%prep
%setup -q -n %{pkgname}-%{version}
%patch0 -p1 -b .cleanup
%patch1 -p1 -b .fhs
%patch2 -p0

autoreconf -fiv

bzip2 -dc %{SOURCE2} > README.debian

# (Abel) supress annoying rpmlint warning message
perl -pi -e 's/\r//g' [[:upper:]][[:upper:]]* ChangeLog

%build
%configure \
	--bindir=%{_gamesbindir} \
	--datadir=%{_gamesdatadir}
%make_build

%install
%makeinstall_std

mkdir -p %{buildroot}%{_mandir}/man6
bzip2 -dc %{SOURCE1} > %{buildroot}%{_mandir}/man6/sjeng.6

%files
%doc AUTHORS BUGS ChangeLog NEWS README README.debian
%{_gamesbindir}/*
%{_mandir}/man6/sjeng.6*


%changelog
