# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		smathstudio
Version:	0.99.6671
Release:	alt1_5
Summary:	Small mathematics program with MathCad style
License:	Freeware
Group:		Sciences/Mathematics
URL:		https://en.smath.info/
Source0:	https://smath.info/file/BaH5L/SMathStudioDesktop.%(echo %{version} | sed -e "s/\\./_/g").Mono.tar.gz
Source1:	SSLogo48.png
Requires:	mono-core mono-data mono-data-sqlite mono-extras mono-wcf mono-web
Requires:	mono-winforms
Source44: import.info

%description
A free mathematical package with a graphical interface for the calculation
of mathematical expressions, and constructing two-dimensional and three-
dimensional graphs.

%build
#nothing

%prep
%setup -q -c -n %{name}-%{version}
rm -f %{name}_desktop_mono
gzip lang/*
gzip book/*
gzip examples/*
gzip plugins/*
gzip entries/*
gzip snippets/*
# fix wrong-script-end-of-line-encoding
sed -i 's/\r//' EULA/*
# fix permissions
chmod -x EULA/*
chmod -x book/*
chmod -x snippets/*
chmod -x lang/*
chmod -x entries/*

%install
mkdir -p %{buildroot}%{_datadir}/%{name}
cp -af * %{buildroot}%{_datadir}/%{name}/
rm -rf %{buildroot}%{_datadir}/%{name}/EULA

mkdir -p %{buildroot}%{_datadir}/pixmaps
install -Dm644 %{SOURCE1} %{buildroot}%{_datadir}/pixmaps/%{name}.png

install -dm 755 %{buildroot}%{_datadir}/applications
cat > %{name}.desktop << EOF
[Desktop Entry]
Name=SMathStudio
GenericName=SMath Studio Desktop
Comment=Mathematical editor with MathCad style
Comment[ru]=Математический редактор с MathCad стилем
Exec=%{name}
Icon=%{name}
Type=Application
Categories=Education;Math;
EOF
install -m 0644 %{name}.desktop %{buildroot}%{_datadir}/applications/%{name}.desktop

install -dm 755 %{buildroot}%{_bindir}
cat > %{name} << EOF
#!/bin/bash
cd %{_datadir}/%{name}
exec mono "%{_datadir}/%{name}/SMathStudio_Desktop.exe" "\$@"
EOF
install -m 755 %{name} %{buildroot}%{_bindir}/%{name}

%post
gzip -d %{_datadir}/%{name}/lang/*.gz
gzip -d %{_datadir}/%{name}/examples/*.gz
gzip -d %{_datadir}/%{name}/book/*.gz
gzip -d %{_datadir}/%{name}/plugins/*.gz
gzip -d %{_datadir}/%{name}/entries/*.gz
gzip -d %{_datadir}/%{name}/snippets/*.gz

%pre
if [ $1 -eq 2 ]; then
# delete application directory before upgrade
  rm -rf %{_datadir}/%{name}
fi

%postun
if [ $1 -eq 0 ]; then
# delete application directory after uninstall
  rm -rf %{_datadir}/%{name}
fi

%files
%doc EULA/*
%{_datadir}/%{name}
%{_bindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.png


%changelog
