Group: Communications
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/as libuuid-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name: soundmodem
Version: 0.20
Release: alt2_30
Summary: Soundcard Packet Radio Modem
License: GPLv2+
URL: http://gna.org/projects/soundmodem
Source: http://download.gna.org/soundmodem/%{name}-%{version}.tar.gz
Source1: soundmodem.service
Patch1: %{name}-0.16-dirfix.patch
#fixes security error caused by non-void return in void function
#as function seems used we silently drop it to avoid reusing it.
Patch2: %{name}-0.20-void.patch
Patch3: %{name}-0.20-i386-fix.patch
Patch4: %{name}-0.20-gcc10-fix.patch
Patch5: soundmodem-hamlib42.patch
# Requires: /sbin/ifconfig /sbin/route /sbin/arp
BuildRequires:  gcc-c++
BuildRequires:  gcc
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires: libalsa-devel
BuildRequires: libxml2-devel
BuildRequires: libaudiofile-devel
BuildRequires: hamlib-c++-devel hamlib-devel hamlib-tcl
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
%{?systemd_requires}
Source44: import.info


%description
This package contains the driver and the diagnostic utility for
userspace SoundModem. It allows you to use soundcards
as Amateur Packet Radio modems.

%package devel
Group: Development/Other

Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}

%description    devel
The %{name}-devel package contains libraries and header files for
developing applications that use %{name}.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1


%build
%if "%version" < "0.20"
# Versions prior to 0.20 are not c11 compiliant
# Work-around by fallin back to -std=gnu89
%configure CFLAGS="${RPM_OPT_FLAGS} -std=gnu89"
%else
# Versions >= 0.20 seem to be c11 compliant
%configure
%endif
%make_build

%install
%makeinstall
find %{buildroot} -name '*.la' -exec rm -f {} ';'
mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_sysconfdir}/ax25
mkdir -p %{buildroot}%{_unitdir}
install -p -m 644 %{SOURCE1} %{buildroot}%{_unitdir}/soundmodem.service
mkdir -p %{buildroot}%{_includedir}/%{name}
mv %{buildroot}%{_includedir}/modem.h %{buildroot}%{_includedir}/%{name}
mv %{buildroot}%{_includedir}/simd.h %{buildroot}%{_includedir}/%{name}
%find_lang %{name}

%post
%post_service soundmodem

%preun
%preun_service soundmodem

%files -f %{name}.lang
%{_sbindir}/*
%{_bindir}/*
%{_mandir}/*/*
%{_unitdir}/soundmodem.service
%doc AUTHORS ChangeLog NEWS README newqpsk/README.newqpsk
%doc --no-dereference COPYING

%files devel
%{_includedir}/%{name}

%changelog
