Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           spacenavd
Version:        1.2
Release:        alt1_3
Summary:        A free, compatible alternative for 3Dconnexion's input drivers

License:        GPLv3+
URL:            http://spacenav.sourceforge.net/
Source0:        https://github.com/FreeSpacenav/%{name}/releases/download/v%{version}/%{name}-%{version}.tar.gz
# systemd unit files, for fedora
Source1:        spacenavd.service

BuildRequires:  gcc
BuildRequires:  libX11-devel

BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
%{?systemd_requires}
Source44: import.info


%description
Spacenavd, is a free software replacement user-space driver (daemon), for
3Dconnexion's space-something 6dof input devices. It's compatible with the
original 3dxsrv proprietary daemon provided by 3Dconnexion, and works
perfectly with any program that was written for the 3Dconnexion driver.


%prep
%setup -q



%build
%configure
sed -i "s/CFLAGS =/CFLAGS +=/g" Makefile

%make_build


%install
%makeinstall_std

# Install systemd unit file
mkdir -p %{buildroot}%{_unitdir}
install -p -m 0644 %{SOURCE1} %{buildroot}%{_unitdir}


%post
%post_service spacenavd

%preun
%preun_service spacenavd

%files
%doc AUTHORS doc/* README.md
%doc --no-dereference COPYING
%{_bindir}/*
%{_unitdir}/%{name}.service


%changelog
