# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBD/mysql.pm) perl(DBI.pm) perl(DB_File.pm) perl(Exporter.pm) perl(Fcntl.pm) perl(FileHandle.pm) perl(MLDBM.pm) perl(Mail/SpamAssassin.pm) perl(Mail/SpamAssassin/Logger.pm) perl(Mail/SpamAssassin/Plugin.pm) perl(Mail/SpamAssassin/Timeout.pm) perl(Mail/SpamAssassin/Util.pm) perl(Storable.pm) perl(String/Approx.pm) perl(Time/HiRes.pm) perl(base.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           spamassassin-FuzzyOcr
Version:        3.6.0
Release:        alt1_18
Summary:        Spamassassin plugin to identify image spam
Group:          Networking/WWW
License:        ASL 2.0
URL:            http://fuzzyocr.own-hero.net/
Source0:        http://users.own-hero.net/~decoder/fuzzyocr/fuzzyocr-%{version}.tar.gz
Patch1:         fuzzyocr-fix-untaint-issue.patch
BuildArch:      noarch
Requires:       perl-Mail-SpamAssassin spamassassin spamassassin-spamc spamassassin-spamd perl-String-Approx netpbm ocrad gifsicle libgif-utils
BuildRequires:  /usr/bin/iconv
BuildRequires:  rpm-build-perl
Source44: import.info

%description
FuzzyOcr is a plugin for SpamAssassin which is aimed at unsolicited bulk mail 
(also known as "Spam") containing images as the main content carrier. Using 
different methods, it analyzes the content and properties of images to 
distinguish between normal mails (Ham) and spam mails.


%prep
%setup -q -n FuzzyOcr-%{version}
%patch1 -p1
/usr/bin/perl -pi -e 's|/usr/local/bin/perl|%{__perl}|' Utils/fuzzy-*
/usr/bin/perl -pi -e 's|FuzzyOcr.pm|%{perl_vendor_privlib}/FuzzyOcr.pm|' FuzzyOcr.cf
/usr/bin/perl -pi -e 's|#focr_verbose 3|focr_verbose 0|' FuzzyOcr.cf
sed -i 's/\r//' Utils/README FuzzyOcr.mysql samples/ocr-obfuscated.eml
iconv -f iso8859-1 -t utf-8 samples/ocr-jpg.eml > samples/ocr-jpg.eml.conv && mv -f samples/ocr-jpg.eml.conv samples/ocr-jpg.eml

%build
# nothing to do here

%install
install -d $RPM_BUILD_ROOT/%{_sysconfdir}/mail/spamassassin
install -d $RPM_BUILD_ROOT/%{perl_vendor_privlib}/FuzzyOcr
cp FuzzyOcr/* $RPM_BUILD_ROOT/%{perl_vendor_privlib}/FuzzyOcr/
cp FuzzyOcr.pm $RPM_BUILD_ROOT/%{perl_vendor_privlib}/
cp FuzzyOcr.cf $RPM_BUILD_ROOT/%{_sysconfdir}/mail/spamassassin/
cp FuzzyOcr.preps $RPM_BUILD_ROOT/%{_sysconfdir}/mail/spamassassin/
cp FuzzyOcr.scansets $RPM_BUILD_ROOT/%{_sysconfdir}/mail/spamassassin/
cp FuzzyOcr.words $RPM_BUILD_ROOT/%{_sysconfdir}/mail/spamassassin/



%files
%doc Utils samples INSTALL LICENSE CHANGES FuzzyOcr.mysql
%{perl_vendor_privlib}/*
%config(noreplace) %{_sysconfdir}/mail/spamassassin/*


%changelog
