Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global tag beta.3
%global longtag v0.5-beta.3

Name:           spasm-ng
Version:        0.5
Release:        alt2_0.17.beta.3
Summary:        A z80 assembler with extra features for TI calculators

# spasm-ng is under GPLv2.
# The BSD is the stringencoders sources (modp_ascii.*).
License:        GPLv2 and BSD

URL:            https://github.com/alberthdev/spasm-ng
Source0:        https://github.com/alberthdev/spasm-ng/archive/%{longtag}/%{name}-%{version}-%{tag}.tar.gz

BuildRequires:  gcc, gcc-c++
BuildRequires:  zlib-devel libgmp-devel libgmpxx-devel, libssl-devel

# To run the tests.
BuildRequires:  python3

# For now, provide bundled stringencoders.
Provides:       bundled(stringencoders) = 2011.08.20
Source44: import.info

%description
SPASM-ng is a z80 assembler with extra features to support development
for TI calculators. SPASM-ng can assemble and create assembly programs
and flash applications in formats that can be shipped directly to
TI-z80 (TI-83+, TI-83+SE, TI-84+, TI-83+SE, TI-84+CSE, TI-84+CE)
calculators.

SPASM-ng was originally from the SPASM project, and was forked to fix
a few bugs. It was originally written by Spencer Putt and Don Straney,
with additional development by Chris Shappell and James Montelongo.

This release incorporates eZ80 support in preparation for the launch
of the TI-84+CE. It also greatly increases the limit on the number
of labels that can be defined.

%prep
%setup -qn %{name}-%{version}-%{tag}

# Remove the bundled include files (at least, for now).
# Their authorship and copyright is difficult to assert (most of the community
# written files are not licensed, and ti83plus.inc was originally written by
# TI and then heavily modified), most authors of TI calculator assembly
# projects bundle them with their code anyway, and spasm does not expect include
# files to be available system-wide to begin with.
# The AUR package for Arch makes a similar decision and does not include them.
rm -rf inc/

# Remove the lib/ directory from the download.
rm -rf lib/

# Remove bundled gmp.h header.
rm gmp.h

%build
# For some reason, this has to be invoked as 'make debug'.
LDFLAGS="%{__global_ldflags}" CXXFLAGS="%{optflags}" %make_build debug

%install
# We can't use the make install macro.
mkdir -p %{buildroot}%{_bindir}
make install DESTDIR=%{buildroot}%{_prefix}

%check
make check

%files
%{_bindir}/spasm

%doc README.md
%doc --no-dereference LICENSE

%changelog
