Group: System/Servers
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:    Daemon that can spin idle disks down
Name:       spindown
Version:    0.4.0
Release:    alt1_31
License:    GPLv3+
Url:        http://code.google.com/p/spindown
Source0:    http://spindown.googlecode.com/files/spindown-%{version}.tar.gz
Source1:    spindown.service
Source2:    01spindown

Patch0: spindown-0.4.0-Makefile.patch
Patch1: spindown-0.4.0-iniparser.patch
Patch2: spindown-0.4.0-iniparser-3.0-1.patch
Patch3: spindown-0.4.0-bz1037334.patch
Patch33: spindown-0.4.0-alt-gcc10.patch


BuildRequires:  gcc-c++
BuildRequires: libiniparser-devel
Source44: import.info

%description
Spindown is a daemon that can spin idle disks down and thus save energy and
improve disk lifetime. It periodically checks for read or written blocks. When
no blocks are read or written the disk is idle. When a disk stays idle long
enough, spindown uses custom command like sg_start or hdparm to spin it down.
It also works with USB disks and hot-swappable disks because it doesn't watch
the device name (hda, sdb, ...), but the device ID. This means that it doesn't
matter if the disk is swapped while the daemon is running.

%prep
%setup -q
rm -rf src/ininiparser3.0b
cp -pf %{SOURCE1} spindown.service
cp -pf %{SOURCE2} 01spindown
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch33 -p1

%build
%make_build OPT="$RPM_OPT_FLAGS"

%install
make DESTDIR="$RPM_BUILD_ROOT" install
mkdir -p $RPM_BUILD_ROOT/%{_libdir}/pm-utils/sleep.d
mkdir -p $RPM_BUILD_ROOT/%{_unitdir}
install -p -m 755 01spindown $RPM_BUILD_ROOT/%{_libdir}/pm-utils/sleep.d/01spindown
install -p -m 755 spindown.service $RPM_BUILD_ROOT/%{_unitdir}/spindown.service

%preun
%preun_service spindown

%files
%doc COPYING CHANGELOG README
%{_unitdir}/spindown.service
%{_sbindir}/spindownd
%{_libdir}/pm-utils/sleep.d/01spindown
%config(noreplace) %{_sysconfdir}/spindown.conf

%changelog
