Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 5

%global uuid    im.srain.Srain

Name:           srain
Version:        1.5.1
Release:        alt1_%autorelease
Summary:        Modern, beautiful IRC client written in GTK+ 3

# The entire source code is GPL-3.0-or-later except:
#   * keypair/      which is BSD-2-Clause
#   * sui_side_bar/ which is GPL-2.0-or-later
License:        GPL-3.0-or-later AND BSD-2-Clause AND GPL-2.0-or-later
URL:            https://github.com/SrainApp/srain
Source0:        https://github.com/SrainApp/srain/archive/%{version}/%{name}-%{version}.tar.gz

BuildRequires:  desktop-file-utils
BuildRequires:  gcc
BuildRequires:  intltool
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  meson >= 0.47
BuildRequires:  python3-module-sphinx python3-module-sphinx-sphinx-build-symlink

BuildRequires:  pkgconfig(gtk+-3.0) >= 3.22.15
BuildRequires:  pkgconfig(libconfig) >= 1.5
BuildRequires:  pkgconfig(libsecret-1)
BuildRequires:  pkgconfig(libsoup-2.4)
BuildRequires:  pkgconfig(openssl)

Requires:       icon-theme-hicolor

Requires:       %{name}-doc
Source44: import.info

%description
%{summary}.


%package doc
Group: Other
Summary:        Documentation files for %{name}
BuildArch:      noarch

Requires:       %{name} = %{version}-%{release}

%description doc
Documentation files for %{name}.


%prep
%setup -q



%build
%meson \
    -Ddoc_builders=html,man
%meson_build


%install
%meson_install
%find_lang %{name}


%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/*.xml
desktop-file-validate %{buildroot}%{_datadir}/applications/*.desktop


%files -f %{name}.lang
%doc README.rst
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_datadir}/%{name}/
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/*/*/*.png
%{_mandir}/*1/*.1*
%{_metainfodir}/*.xml
%{_sysconfdir}/%{name}

%files doc
%{_docdir}/%{name}/html/


%changelog
