Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:		srcpd
Version:	2.1.6
Release:	alt1_2
Summary:	Simple Railroad Command Protocol (SRCP) server

License:	GPLv2
URL:		http://srcpd.sourceforge.net/
Source0:	http://sourceforge.net/projects/srcpd/files/srcpd/%{version}/srcpd-%{version}.tar.bz2
Source1:	srcpd.service

Patch0:		srcpd-2.1.6-io-conditional.patch
Patch1:		srcpd-2.1.6-udev.patch

BuildRequires:		gcc
BuildRequires:		libxml2-devel

BuildRequires:		libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd systemd-portable systemd-sysvinit
Source44: import.info


%description
Simple Railroad Command Protocol (SRCP) is a communication protocol designed
to integrate various models of railroad systems. The srcpd acts a gateway
between any kind of model railway systems and user interface programs that
support SRCP. IANA assigned TCP port 4303 to it.


%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
%configure
%make_build


%install
%makeinstall_std
%find_lang %{name} --with-man --all-name

install -Dpm 0644 %SOURCE1 %{buildroot}/%{_unitdir}/srcpd.service
rm -rf %{buildroot}/%{_sysconfdir}/udev
install -Dpm 0644 10-liusb.rules %{buildroot}/%{_udevrulesdir}/10-liusb.rules


%post
%post_service %{name}
exit 0


%preun
%preun_service %{name}
exit 0


%files -f %{name}.lang
%doc AUTHORS COPYING ChangeLog DESIGN NEWS PROGRAMMING-HOWTO TODO
%doc README README.loconet README.selectrix
%config(noreplace) %{_sysconfdir}/srcpd.conf
%config(noreplace) %{_udevrulesdir}/10-liusb.rules
%{_unitdir}/%{name}.service
%{_sbindir}/srcpd
%{_mandir}/man5/*.5*
%{_mandir}/man8/*.8*


%changelog
