Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:        SSL/TLS network protocol analyzer
Name:           ssldump
Version:        1.8
Release:        alt1_2
# pcap/{attrib.h,{logpkt,sys}.[ch]} are BSD-2-Clause, rest is BSD-4-Clause
License:        BSD-4-Clause AND BSD-2-Clause
URL:            https://github.com/adulau/ssldump
Source0:        https://github.com/adulau/ssldump/archive/v%{version}/%{name}-%{version}.tar.gz
Source1:        HOWTO
Patch0:         https://github.com/adulau/ssldump/commit/44e963d12e6b25ba6f430aae8cf1b8142bcbab33.patch#/ssldump-1.8-cmake.patch
BuildRequires:  ctest cmake
%if 0%{?rhel} && 0%{?rhel} < 8
BuildRequires:  ccmake cmake ctest
%endif
BuildRequires:  gcc
%if 0%{?fedora} || 0%{?rhel} > 7
BuildRequires:  libssl-devel
%else
BuildRequires:  openssl11-devel
%endif
BuildRequires:  libpcap-devel
BuildRequires:  libnet2-devel
BuildRequires:  libjson-c-devel
Source44: import.info

%description
The ssldump program is an SSL/TLS network protocol analyzer. It identifies
TCP connections on the chosen network interface and attempts to interpret
them as SSL/TLS traffic. When ssldump identifies SSL/TLS traffic, ssldump
decodes the records and displays them in a textual form to stdout. And if
provided with the appropriate keying material, ssldump will also decrypt
the connections and display the application data traffic. This program is
based on tcpdump, a network monitoring and data acquisition tool.

%prep
%setup -q
%patch0 -p1

install -p -m 0644 %{SOURCE1} .

%build
%if 0%{?rhel} && 0%{?rhel} < 8
%global cmake %{fedora_v2_cmake3}
%global cmake_build %fedora_v2_cmake3_build
%global cmake_install %fedora_v2_cmake3_install

export CFLAGS="$RPM_OPT_FLAGS -D_BSD_SOURCE"
%endif

%{fedora_v2_cmake} \
%if 0%{?rhel} && 0%{?rhel} < 8
  -DOPENSSL_ROOT_DIR:PATH="%{_includedir}/openssl11;%{_libdir}/openssl11"
%endif

%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

%files
%doc --no-dereference COPYRIGHT
%doc ChangeLog CREDITS HOWTO README README.md
%{_bindir}/%{name}
%{_mandir}/man1/%{name}.1*

%changelog
