Group: Engineering
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate /usr/bin/open
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary:	3-dimensional perspective star map viewer
Name:		starplot
Version:	0.95.5
Release:	alt2_39

# See README
# SPDX confirmed
License:	GPL-2.0-or-later
URL:		http://starplot.org/
Source0:	http://starplot.org/downloads/%{name}-%{version}.tar.gz

Patch0:		%{name}-%{version}-desktop.patch
# Fix build with -Werror=format-security"
Patch1:         %{name}-%{version}-rhbz1037339.patch
# C++11 build fix
Patch2:         %{name}-%{version}-rhbz1308152.patch
# Fix segv on startup (bug 1322030)
Patch3:		starplot-0.95.5-qsort_vs_new-bz1322030.patch
# SpecClass::initialize: Fix invalid access when luminosity class ends at
# the end of the line (bug 2029228)
Patch4:		starplot-0.95.5-specclass-init-at-operator.patch

Requires:	xdg-utils

BuildRequires:	gcc-c++
BuildRequires:	desktop-file-utils
BuildRequires:	gettext-tools
BuildRequires:	gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:	xdg-utils
Source44: import.info

%description
StarPlot is a GTK+ based program, written in C++, which can be used
interactively to view three-dimensional perspective charts of stars.

%prep
%setup -q
%patch0  -p1
%patch1  -p1 -b .format
%patch2  -p1 -b .c++11
%patch3  -p1 -b .new_qsort
%patch4  -p1 -b .specclass_init

# Suppress rpmlint error.
iconv --from-code ISO8859-1 --to-code UTF-8 ./doc/examples/example.spec \
  --output example.utf-8 && mv example.utf-8 ./doc/examples/example.spec

# Fix "_STRING_H" name conflict
sed -i src/classes/strings.h \
	-e '\@def.*_STRINGS_H@s@_STRINGS_H@STARPLOT_STRINGS_H@'

%build
%configure \
  --docdir=%{_docdir}/%{name} \
  --disable-rpath \
  --with-webbrowser=xdg-open
%make_build

%install
%makeinstall_std

# Remove *.stars files from documentation.
rm -f ./doc/examples/*.stars

%find_lang %{name}

%check
desktop-file-validate $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%files -f %{name}.lang
%doc AUTHORS
%doc ChangeLog
%doc --no-dereference COPYING
%doc NEWS
%doc NLS-TEAM
%doc README
%doc TODO
%doc doc/examples
%doc doc/html

%{_bindir}/%{name}
%{_bindir}/starconvert
%{_bindir}/starpkg
%{_datadir}/applications/*%{name}.desktop
%{_datadir}/pixmaps/%{name}32x32.xpm
%{_mandir}/man1/%{name}.1*
%{_mandir}/man1/starconvert.1*
%{_mandir}/man1/starpkg.1*

%dir %{_datadir}/%{name}
%{_datadir}/%{name}/sample.stars
%{_datadir}/%{name}/test.stars

%changelog
