# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-mageia-compat
BuildRequires: gcc-c++ perl(Tk.pm) perl(Tk/Xrm.pm) pkgconfig(expat) pkgconfig(libbrotlidec) pkgconfig(libpcre2-8) pkgconfig(uuid) pkgconfig(xinerama)
# END SourceDeps(oneline)
BuildRequires: zlib-devel bzlib-devel
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define _disable_ld_no_undefined 1

Summary:	Dance and rhythm game with 3D graphics and dance pad support
Name:		stepmania
Version:	5.1
Release:	alt1_1.b1
License:	MIT
Url:		https://www.stepmania.com/
Group:		Games/Arcade
# Repack to unbundle external deps and remove everything that we don't need
# Patched stuff that can't be removed as of 5.0-beta4a: crypto, lua5.1
# snapshot on 2022-11-14 at d55acb1ba26f1c5b5e3048d6d6c0bd116625216f commit
# fixed src/RageUtil.cpp line 1468 WITH_SYSTEM_PCRE is not passed
# https://github.com/stepmania/stepmania/issues/2240
Source0:	%{name}-%{version}.tar.xz
Source1:	clean-tarball.sh

BuildRequires:	pkgconfig(alsa)
BuildRequires:	pkgconfig(bzip2)
BuildRequires:	pkgconfig(gl)
BuildRequires:	pkgconfig(glew)
BuildRequires:	pkgconfig(glu)
BuildRequires:	pkgconfig(gtk+-2.0)
BuildRequires:	pkgconfig(jack)
BuildRequires:	pkgconfig(jsoncpp)
BuildRequires:	pkgconfig(libjpeg)
BuildRequires:	pkgconfig(libpcre)
BuildRequires:	pkgconfig(libpng)
BuildRequires:	pkgconfig(libpulse)
BuildRequires:	pkgconfig(mad)
BuildRequires:	pkgconfig(ogg)
BuildRequires:	pkgconfig(sdl)
BuildRequires:	pkgconfig(libtomcrypt)
BuildRequires:	pkgconfig(libtommath)
BuildRequires:	pkgconfig(udev)
BuildRequires:	pkgconfig(vorbisfile)
BuildRequires:	pkgconfig(x11)
BuildRequires:	pkgconfig(xrandr)
BuildRequires:	pkgconfig(xtst)
BuildRequires:	pkgconfig(zlib)
BuildRequires:	ccmake cmake ctest
Requires:	%{name}-data = %{version}-%{release}
Requires:	%{name}-stepmix1
Source44: import.info

%description
StepMania is a music/rhythm game. The player presses different buttons in time
to the music and to note patterns that scroll across the screen. Features 3D
graphics, visualizations, support for gamepads/dance pads, a step recording
mode, and more!
To add songs, simply copy the content of your folder containing songs
to ~/.stepmania-5.1/Songs.

%package	data
Group: Games/Arcade
Summary:	Data files for StepMania
BuildArch:	noarch
#Obsoletes:	stepmania-data < 3.9-13

%description	data
This package contains arch-independent data files to be used with StepMania.

%prep
%setup -q
sed -i -e '/PCRE_INCLUDE_DIR/s,pcre\.h,pcre/pcre.h,' CMake/Modules/FindPcre.cmake
sed -i -e 's,#include <pcre.h>,#include <pcre/pcre.h>,' src/RageUtil.cpp
sed -i -e 's,pcre\.h,pcre/pcre.h,' configure.ac

%add_optflags -I/usr/include/tomcrypt
%build
# workaround harfbuzz header path since pango 1.44.0
export CPATH="${CPATH}:%{_includedir}/harfbuzz"

%ifarch %arm
export CFLAGS="%optflags -DLTC_NO_ASM"
export CXXFLAGS="%optflags -DLTC_NO_ASM"
%endif

# Very noisy warning about auto_ptr which is used a lot
export CXXFLAGS="$CXXFLAGS -Wno-deprecated-declarations"

%{mageia_cmake} \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_INSTALL_PREFIX=%{_gamesdatadir} \
	-DWITH_FFMPEG=OFF \
	-DWITH_MINIMAID=OFF \
	-DWITH_SYSTEM_PCRE=ON \
	-DWITH_SYSTEM_GLEW=ON \
	-DWITH_SYSTEM_JPEG=ON \
	-DWITH_SYSTEM_PNG=ON \
	-DWITH_SYSTEM_TOMCRYPT=ON \
	-DWITH_SYSTEM_TOMMATH=ON \
	-DWITH_SYSTEM_ZLIB=ON \
	-DWITH_SYSTEM_JSONCPP=ON \
	-DWITH_SYSTEM_MAD=ON \
	-DWITH_SYSTEM_OGG=ON \
%ifnarch x86_64
	-DWITH_SSE2=OFF \
%endif
%ifnarch %{ix86} x86_64
	-DWITH_PARALLEL_PORT=OFF \
	-DWITH_CRASH_HANDLER=OFF \
%endif

%mageia_cmake_build

%install
%mageia_cmake_install

# Binary and GtkModule.so
mkdir -p %{buildroot}%{_libexecdir}/%{name}/
mv %{buildroot}%{_gamesdatadir}/%{name}-5.1/stepmania %{buildroot}%{_libexecdir}/%{name}/
# mv %{buildroot}%{_gamesdatadir}/%{name}-5.1/GtkModule.so %{buildroot}%{_libexecdir}/%{name}/

# Icons
install -d %{buildroot}%{_iconsdir}
cp -a icons/hicolor %{buildroot}%{_iconsdir}/

# Desktop entry
install -d %{buildroot}%{_datadir}/applications
cat << EOF > %{buildroot}%{_datadir}/applications/%{name}.desktop
[Desktop Entry]
Name=StepMania
GenericName=Rhythm game
Comment=Dance and rhythm game with 3D graphics and dance pad support
Exec=%{name}
Icon=%{name}-ssc
Categories=Game;ArcadeGame;
Type=Application
EOF

# Wrapper
mkdir -p %{buildroot}%{_gamesbindir}
cat << EOF > %{buildroot}%{_gamesbindir}/%{name}
#!/bin/sh
cd %{_gamesdatadir}/%{name}-5.1/
%{_libexecdir}/%{name}/stepmania
EOF
chmod 0755 %{buildroot}%{_gamesbindir}/%{name}

%files
%doc README.md Manual/ Docs/credits.txt
%doc README.md Manual/ Docs/CommandLineArgs.txt
%doc README.md Manual/ Docs/Changelog_sm5.txt
%{_gamesbindir}/%{name}
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/%{name}-ssc.*
%{_libexecdir}/%{name}/

%files		data
%{_gamesdatadir}/%{name}-5.1/


%changelog
