# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define	major 0
%define libname libmodpbase64_%{major}
%define develname libmodpbase64-devel

Summary:	A collection of high performance c-string transformations
Name:		stringencoders
Version:	3.10.3
Release:	alt1_9
Group:		System/Libraries
License:	BSD
URL:		http://code.google.com/p/stringencoders/
Source0:	http://stringencoders.googlecode.com/files/%{name}-v%{version}.tar.gz
Patch0:		01-ignore-warnings.patch
Patch1:		02-pkgconfig.patch
Patch2:		03-endianness.patch
Patch3:		stringencoders-v3.10.3-aclocal-1.13.diff
BuildRequires:	autoconf 
BuildRequires:	automake 
BuildRequires:	libtool
Source44: import.info

%description
This implementation is frequently 2x faster than standard implementations.
The transformations include base64, base16, base85, base2, url and javascript
escaping, as well as fast number to string and upper/lower case conversions.

%package -n	%{libname}
Summary:	High performance c-string transformations library
Group:		System/Libraries

%description -n	%{libname}
Collection of high performance c-string transformations.

This implementation is frequently 2x faster than standard implementations.
The transformations include base64, base16, base85, base2, url and javascript
escaping, as well as fast number to string and upper/lower case conversions.


%package -n	%{develname}
Summary:	Development files for the stringencoders library
Group:		Development/C
Provides:	%{name}-devel = %{version}-%{release}
Requires:	%{libname} >= %{version}

%description -n	%{develname}
Collection of high performance c-string transformations (development files)

This implementation is frequently 2x faster than standard implementations.
The transformations include base64, base16, base85, base2, url and javascript
escaping, as well as fast number to string and upper/lower case conversions.

%prep

%setup -q -n %{name}-v%{version}
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p0

%build
autoreconf -fi

%configure \
    --disable-static

%make_build

%check
make test

%install
%makeinstall_std

rm -f %{buildroot}%{_libdir}/*.la

%files -n %{libname}
%doc AUTHORS COPYING ChangeLog NEWS
%{_libdir}/*.so.%{major}
%{_libdir}/*.so.%{major}.*

%files -n %{develname}
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc



%changelog
