Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global pkgdate 20041208

Name:           sunwait
Summary:        Calculate sunrise, sunset, twilight
Version:        0.1
Release:        alt2_0.22.%{pkgdate}
License:        GPLv2+
URL:            http://www.risacher.org/sunwait/
Source0:        http://www.risacher.org/sunwait/sunwait-%{pkgdate}.tar.gz
Source1:        http://www.risacher.org/sunwait/index.html

# patch to include string.h header to avoid warning
Patch0:         sunwait-string.patch
Patch1:         sunwait-c99.patch

# As of 20-DEC-2014, the source code for the new fork sunwait4windows
# is not being provided in any archive format conducive for packaging,
# so I'm using the author's 2004 release, which still works fine.
# I'll contact Ian Craig, maintainer of the fork, about better source
# release packaging.

# Upstream notified of incorrect-fsf-address by email on 20-DEC-2014
# Requested man page of upstream by email on 25-FEB-2015

BuildRequires:  gcc
Source44: import.info
%description
Sunwait is a small C program for calculating sunrise and sunset, as
well as civil, nautical, and astronomical twilights. It has features
that make it useful for home automation tasks.

%prep
%setup -q -n %{name}-%{pkgdate}
%patch0 -p1 -b .string
%patch1 -p1
cp -p %{SOURCE1} sunwait.html

%build
%make_build CFLAGS="${RPM_OPT_FLAGS}"

%install
install -d -m 755 ${RPM_BUILD_ROOT}/%{_bindir}
install -m 755 sunwait ${RPM_BUILD_ROOT}/%{_bindir}

%files
%doc --no-dereference COPYING
%doc sunwait.html
%{_bindir}/sunwait

%changelog
