Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           surf
Version:        2.0
Release:        alt2_15
Summary:        Simple web browser
License:        MIT
URL:            http://surf.suckless.org/

Source0:        http://dl.suckless.org/%{name}/%{name}-%{version}.tar.gz
Source1:        %{name}.desktop
Source2:        %{name}.svg

BuildRequires:  gcc
BuildRequires:  pkgconfig(gtk+-3.0)
BuildRequires:  pkgconfig(webkit2gtk-4.0)
BuildRequires:  desktop-file-utils

Requires:       st
Requires:       dmenu
# https://bugzilla.redhat.com/show_bug.cgi?id=841348
Requires:       xprop
# https://bugzilla.redhat.com/show_bug.cgi?id=884296
Requires:       xterm
Requires:       wget, curl
Source44: import.info
# Appdata file needed later.

%description
surf is a simple web browser based on WebKit/GTK+.

%prep
%setup -q


# Thanks to Robert Scheck for the DSO-patch
# https://bugzilla.redhat.com/attachment.cgi?id=402128
# I decided to include this in the sed chain below
sed \
  -e 's|/usr/local|%{_prefix}|g' \
  -e 's|/usr/lib|%{_libdir}|g' \
  -e 's|/usr/include|%{_includedir}|g' \
  -e 's|/usr/X11R6/include|%{_includedir}/X11|g' \
  -e 's|/usr/X11R6/lib|%{_libdir}/X11|g' \
  -e 's|/lib/surf|/%{_lib}/surf|g' \
  -e 's|-s ${LIBS}|-g ${LIBS}|g' \
  -e 's|-std=c99 -pedantic -Wall -Os ${INCS} ${CPPFLAGS}|-std=c99 -pedantic %{optflags} ${INCS} ${CPPFLAGS}|g' \
  -e 's|LIBS = -L/usr/lib -lc ${GTKLIB} -lgthread-2.0|LIBS = -L%{_libdir} -lc ${GTKLIB} -lgthread-2.0 -lX11|g' \
  -i config.mk

sed -i 's!^\(\t\+\)@!\1!' Makefile

%build
%make_build

%install
%makeinstall_std INSTALL="install -p"

desktop-file-install %{S:1} --dir=%{buildroot}%{_datadir}/applications/

mkdir -p %{buildroot}%{_datadir}/pixmaps/
install -pm0644 %{S:2} %{buildroot}%{_datadir}/pixmaps/

%files
%doc --no-dereference LICENSE
%{_bindir}/%{name}
%{_mandir}/man*/%{name}.*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/pixmaps/%{name}.svg

%changelog
